/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.processor.MergingGraphRequestProcessor;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;

public class SessionDebugger
extends Composite {
    private Session session;
    private MergingGraphRequestProcessor updater;
    private TreeViewer clusters;
    private ChangeListener changeListener = new ChangeListener(){

        public void graphChanged(ChangeEvent e) {
            SessionDebugger.this.updater.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    SessionDebugger.this.updateContent();
                }
            });
        }
    };

    public SessionDebugger(Composite parent, int style, final Session session) {
        super(parent, style);
        Assert.isNotNull((Object)session, (String)"session is null");
        this.session = session;
        this.updater = new MergingGraphRequestProcessor((AsyncRequestProcessor)session, 100L);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GraphChangeListenerSupport support = (GraphChangeListenerSupport)session.getService(GraphChangeListenerSupport.class);
                support.removeListener(SessionDebugger.this.changeListener);
            }
        });
    }

    public void initializeUI() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createViewer(this);
    }

    public TreeViewer createViewer(Composite parent) {
        this.clusters = new TreeViewer(parent, 0);
        this.clusters.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.clusters.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return new Object[0];
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.refreshClusters();
        GraphChangeListenerSupport support = (GraphChangeListenerSupport)this.session.getService(GraphChangeListenerSupport.class);
        support.addListener(this.changeListener);
        return this.clusters;
    }

    public void refreshClusters() {
        this.updater.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                SessionDebugger.this.updateContent();
            }
        });
    }

    public void updateContent() {
        this.clusters.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SessionDebugger.this.clusters.getTree().isDisposed()) {
                    return;
                }
                SessionDebugger.this.clusters.setInput(new Object());
            }
        });
    }
}

