/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchSite;
import org.osgi.framework.Bundle;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.Queries;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.uri.ResourceToPossibleURI;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.layer0.adapter.StringModifier;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.service.XSupport;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.debug.ui.internal.DebugUtils;
import org.simantics.debug.ui.internal.HashMultiMap;
import org.simantics.layer0.Layer0;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.ResourceReferenceTransfer;
import org.simantics.ui.dnd.ResourceTransferUtils;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.Container;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.PathUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class GraphDebugger
extends Composite {
    private static final String STATEMENT_PART_SEPARATOR = ",";
    private static final String DEFAULT_DEBUGGER_CSS_FILE = "debugger.css";
    private static final String DEFAULT_DEBUGGER_CSS_PATH = "css/debugger.css";
    private static int RESOURCE_NAME_MAX_LENGTH = 1000;
    private static int RESOURCE_VALUE_MAX_SIZE = 16384;
    private final LocalResourceManager resourceManager;
    private String cssPath;
    private Browser browser;
    private final ColorDescriptor green = ColorDescriptor.createFrom((RGB)new RGB(87, 188, 149));
    private final boolean displayClusters = true;
    private final BijectionMap<String, Resource> links = new BijectionMap();
    private final LinkedList<Resource> backHistory = new LinkedList();
    private final LinkedList<Resource> forwardHistory = new LinkedList();
    private Resource currentElement = null;
    private final Session session;
    private final CopyOnWriteArrayList<HistoryListener> historyListeners = new CopyOnWriteArrayList();
    private final AsyncRequestProcessor updater;
    protected Layer0 L0;
    protected IWorkbenchSite site;
    private final ChangeListener changeListener = new ChangeListener(){

        public void graphChanged(ChangeEvent e) {
            GraphDebugger.this.updater.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    GraphDebugger.this.updateContent(graph, GraphDebugger.this.currentElement);
                }
            });
        }
    };
    private static final String DONT_TOUCH = "DONT_TOUCH";
    private static final String PROMPT_TEXT = "Enter resource ID (RID) or URI";

    public GraphDebugger(Composite parent, int style, Session session, Resource resource, IWorkbenchSite site) {
        this(parent, style, session, resource);
        this.site = site;
    }

    public GraphDebugger(Composite parent, int style, final Session session, Resource resource) {
        super(parent, style);
        Assert.isNotNull((Object)session, (String)"session is null");
        this.session = session;
        this.currentElement = resource;
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.updater = session;
        this.initializeCSS();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                GraphChangeListenerSupport support = (GraphChangeListenerSupport)session.getService(GraphChangeListenerSupport.class);
                support.removeListener(GraphDebugger.this.changeListener);
            }
        });
    }

    protected void setStatus(String message, String error) {
        IStatusLineManager status = WorkbenchUtils.getStatusLine((IWorkbenchSite)this.site);
        if (status != null) {
            if (message != DONT_TOUCH) {
                status.setMessage(message);
            }
            if (error != DONT_TOUCH) {
                status.setErrorMessage(error);
            }
        }
    }

    public void defaultInitializeUI() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createResourceText(this);
        this.createDropLabel(this);
        this.createBrowser(this);
    }

    protected void initializeCSS() {
        try {
            IPath absolutePath = PathUtils.getAbsolutePath((String)"org.simantics.debug.ui", (String)DEFAULT_DEBUGGER_CSS_PATH);
            if (absolutePath != null) {
                this.cssPath = absolutePath.toFile().toURI().toString();
            } else {
                File tempDir = FileUtils.getOrCreateTemporaryDirectory((boolean)false, (String[])new String[0]);
                File css = new File(tempDir, DEFAULT_DEBUGGER_CSS_FILE);
                if (!css.exists()) {
                    URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(DEFAULT_DEBUGGER_CSS_PATH), null);
                    if (url == null) {
                        throw new FileNotFoundException("Could not find 'css/debugger.css' in bundle 'org.simantics.debug.ui'");
                    }
                    this.cssPath = FileUtils.copyResource((URL)url, (File)css, (boolean)true).toURI().toString();
                } else {
                    this.cssPath = css.toURI().toString();
                }
            }
        }
        catch (IOException e) {
            ErrorLogger.defaultLogWarning((Throwable)e);
        }
    }

    public void createResourceText(final Composite parent) {
        final Text text = new Text(parent, 2048);
        text.setForeground(parent.getDisplay().getSystemColor(16));
        text.setText(PROMPT_TEXT);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)text);
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (text.getText().trim().equals("")) {
                    text.setForeground(parent.getDisplay().getSystemColor(16));
                    text.setText(GraphDebugger.PROMPT_TEXT);
                }
            }

            public void focusGained(FocusEvent e) {
                if (text.getText().trim().equals(GraphDebugger.PROMPT_TEXT)) {
                    text.setForeground(parent.getDisplay().getSystemColor(2));
                    text.setText("");
                }
                text.selectAll();
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    String input = text.getText();
                    GraphDebugger.this.setLookupInput(input);
                }
            }
        });
        final Button button = new Button(parent, 0x800000);
        button.setText("&Lookup");
        button.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)button);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    String input = text.getText();
                    GraphDebugger.this.setLookupInput(input);
                    button.setFocus();
                }
            }
        });
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String input = text.getText();
                GraphDebugger.this.setLookupInput(input);
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String input = text.getText().trim();
                if (!input.equals(GraphDebugger.PROMPT_TEXT) && !input.equals("")) {
                    button.setEnabled(true);
                } else {
                    button.setEnabled(false);
                }
            }
        });
    }

    public void setLookupInput(String input) {
        Resource r;
        input = input.trim();
        SerialisationSupport support = (SerialisationSupport)this.session.getService(SerialisationSupport.class);
        if (input.startsWith("$")) {
            try {
                Resource r2 = support.getResource(Long.parseLong(input.substring(1)));
                this.changeLocation(r2);
            }
            catch (NumberFormatException numberFormatException) {
                this.setStatus(DONT_TOUCH, "Invalid '$'-prefixed input, expected resource ID");
            }
            catch (Exception e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
                this.setStatus(DONT_TOUCH, "Resource ID lookup failed. See Error Log.");
            }
            return;
        }
        String[] parts = input.split("-");
        if (parts.length == 1) {
            try {
                int resourceKey = Integer.parseInt(parts[0].trim());
                r = support.getResource(resourceKey);
                ClusteringSupport cs = (ClusteringSupport)this.session.getService(ClusteringSupport.class);
                long cluster = cs.getCluster(r);
                if (cluster > 0L) {
                    this.changeLocation(r);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setStatus(DONT_TOUCH, "Invalid input, expected transient resource ID");
            }
            catch (Exception e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
                this.setStatus(DONT_TOUCH, "Transient resource ID lookup failed. See Error Log.");
            }
        } else if (parts.length == 2) {
            try {
                int resourceIndex = Integer.parseInt(parts[1]);
                long clusterId = Long.parseLong(parts[0]);
                ClusteringSupport cs = (ClusteringSupport)this.session.getService(ClusteringSupport.class);
                Resource r3 = cs.getResourceByIndexAndCluster(resourceIndex, clusterId);
                this.changeLocation(r3);
            }
            catch (NumberFormatException numberFormatException) {
                this.setStatus(DONT_TOUCH, "Invalid input, expected index & cluster IDs");
            }
            catch (Exception e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
                this.setStatus(DONT_TOUCH, "Index & cluster -based lookup failed. See Error Log.");
            }
        }
        try {
            String uri = input;
            if (!input.equals("http:/") && input.endsWith("/")) {
                uri = input.substring(0, input.length() - 1);
            }
            new URI(uri);
            r = (Resource)this.session.syncRequest(Queries.resource((String)uri));
            this.changeLocation(r);
            return;
        }
        catch (URISyntaxException uRISyntaxException) {
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            this.setStatus(DONT_TOUCH, "Resource for URI '" + input + "' not found");
            return;
        }
        catch (DatabaseException e1) {
            this.setStatus(DONT_TOUCH, "URI lookup failed. See Error Log.");
            ErrorLogger.defaultLogError((Throwable)e1);
        }
        this.setStatus(DONT_TOUCH, "Invalid input, resource ID or URI expected");
    }

    public Label createDropLabel(Composite parent) {
        final Label label = new Label(parent, 2048);
        label.setAlignment(0x1000000);
        label.setText("Drag a resource here to examine it in this debugger!");
        label.setForeground(parent.getDisplay().getSystemColor(16));
        GridDataFactory.fillDefaults().align(4, 4).hint(-1, 20).span(2, 1).grab(true, false).applyTo((Control)label);
        DropTarget dropTarget = new DropTarget((Control)label, 5);
        dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance(), ResourceReferenceTransfer.getInstance(), LocalObjectTransfer.getTransfer()});
        dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
                label.setBackground((Color)GraphDebugger.this.resourceManager.get((DeviceResourceDescriptor)GraphDebugger.this.green));
            }

            public void dragLeave(DropTargetEvent event) {
                label.setBackground(null);
            }

            public void drop(DropTargetEvent event) {
                label.setBackground(null);
                ResourceArray[] data = this.parseEventData(event);
                if (data == null || data.length != 1) {
                    event.detail = 0;
                    return;
                }
                ResourceArray array = data[0];
                Resource r = array.resources[array.resources.length - 1];
                GraphDebugger.this.changeLocation(r);
            }

            private ResourceArray[] parseEventData(DropTargetEvent event) {
                ResourceArray[] ret;
                if (event.data instanceof String) {
                    try {
                        SerialisationSupport support = (SerialisationSupport)GraphDebugger.this.session.getService(SerialisationSupport.class);
                        return ResourceTransferUtils.readStringTransferable((SerialisationSupport)support, (String)((String)event.data)).toResourceArrayArray();
                    }
                    catch (IllegalArgumentException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                if ((ret = ResourceAdaptionUtils.toResourceArrays((Object)event.data)).length > 0) {
                    return ret;
                }
                return null;
            }
        });
        return label;
    }

    public Browser createBrowser(Composite parent) {
        try {
            this.browser = new Browser(parent, 32768);
        }
        catch (SWTError sWTError) {
            this.browser = new Browser(parent, 0);
        }
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.browser);
        this.browser.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 8) {
                    GraphDebugger.this.back();
                }
                if (e.keyCode == 0x100000E) {
                    GraphDebugger.this.refreshBrowser();
                }
                if ((e.stateMask & 0x10000) != 0) {
                    if (e.keyCode == 0x1000004) {
                        GraphDebugger.this.forward();
                    }
                    if (e.keyCode == 0x1000003) {
                        GraphDebugger.this.back();
                    }
                }
            }
        });
        this.browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (location.startsWith("simantics:browser")) {
                    location = "about:" + location.substring(17);
                }
                event.doit = false;
                if ("about:blank".equals(location)) {
                    event.doit = true;
                }
                if (location.startsWith("about:-link")) {
                    String target = location.replace("about:-link", "");
                    Resource element = (Resource)GraphDebugger.this.links.getRight((Object)target);
                    if (element == GraphDebugger.this.currentElement) {
                        event.doit = false;
                        return;
                    }
                    GraphDebugger.this.changeLocation(element);
                } else if (location.startsWith("about:-remove")) {
                    String target = location.replace("about:-remove", "");
                    String[] n = target.split(GraphDebugger.STATEMENT_PART_SEPARATOR);
                    if (n.length != 3) {
                        return;
                    }
                    final Resource s = (Resource)GraphDebugger.this.links.getRight((Object)n[0]);
                    final Resource p = (Resource)GraphDebugger.this.links.getRight((Object)n[1]);
                    final Resource o = (Resource)GraphDebugger.this.links.getRight((Object)n[2]);
                    MessageDialog md = new MessageDialog(GraphDebugger.this.getShell(), "Confirm action...", null, "This action will remove the selected statement.\nAre you sure you want to proceed with this action?", 3, new String[]{"Cancel", "Continue"}, 0);
                    if (md.open() != 1) {
                        return;
                    }
                    GraphDebugger.this.session.asyncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph g) throws DatabaseException {
                            List ls;
                            try {
                                ls = OrderedSetUtils.toList((ReadGraph)g, (Resource)s);
                                if (ls.contains(o)) {
                                    OrderedSetUtils.remove((WriteGraph)g, (Resource)s, (Resource)o);
                                }
                            }
                            catch (DatabaseException databaseException) {}
                            try {
                                ls = ListUtils.toList((ReadGraph)g, (Resource)s);
                                if (ls.contains(o)) {
                                    ListUtils.removeElement((WriteGraph)g, (Resource)s, (Resource)o);
                                }
                            }
                            catch (DatabaseException databaseException) {}
                            g.denyStatement(s, p, o);
                        }
                    }, (Callback)new Callback<DatabaseException>(){

                        public void run(DatabaseException parameter) {
                            GraphDebugger.this.refreshBrowser();
                        }
                    });
                } else if (location.startsWith("about:-edit-value")) {
                    String target = location.replace("about:-edit-value", "");
                    final Resource o = (Resource)GraphDebugger.this.links.getRight((Object)target);
                    GraphDebugger.this.session.asyncRequest((Read)new ReadRequest(){
                        String previousValue;

                        public void run(ReadGraph graph) throws DatabaseException {
                            this.previousValue = GraphDebugger.this.getResourceName(graph, o);
                            final StringModifier modifier = (StringModifier)graph.adapt(o, StringModifier.class);
                            GraphDebugger.this.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    InputDialog dialog = new InputDialog(GraphDebugger.this.getShell(), "Edit Value", null, previousValue, new IInputValidator(){

                                        public String isValid(String newText) {
                                            return modifier.isValid((Object)newText);
                                        }
                                    }){
                                        private static final String DIALOG = "DebuggerEditValueDialog";
                                        private IDialogSettings dialogBoundsSettings;

                                        protected IDialogSettings getDialogBoundsSettings() {
                                            if (this.dialogBoundsSettings == null) {
                                                IDialogSettings settings = Activator.getDefault().getDialogSettings();
                                                this.dialogBoundsSettings = settings.getSection(DIALOG);
                                                if (this.dialogBoundsSettings == null) {
                                                    this.dialogBoundsSettings = settings.addNewSection(DIALOG);
                                                }
                                            }
                                            return this.dialogBoundsSettings;
                                        }

                                        protected Point getInitialSize() {
                                            Point result;
                                            Point defaultSize = this.getShell().computeSize(-1, -1, true);
                                            if (defaultSize.equals((Object)(result = super.getInitialSize()))) {
                                                return new Point(600, 400);
                                            }
                                            return result;
                                        }

                                        protected int getShellStyle() {
                                            return super.getShellStyle() | 0x10;
                                        }

                                        protected Control createDialogArea(Composite parent) {
                                            Composite composite = (Composite)super.createDialogArea(parent);
                                            this.getText().setLayoutData((Object)new GridData(1808));
                                            Label label = new Label(composite, 0);
                                            label.moveAbove((Control)this.getText());
                                            label.setText("Input new property value. For numeric vector values, separate numbers with comma (',').");
                                            GridData data = new GridData(772);
                                            data.widthHint = this.convertHorizontalDLUsToPixels(300);
                                            label.setLayoutData((Object)data);
                                            label.setFont(parent.getFont());
                                            return composite;
                                        }

                                        protected int getInputTextStyle() {
                                            return 2050;
                                        }
                                    };
                                    int ok = dialog.open();
                                    if (ok != 0) {
                                        return;
                                    }
                                    final String value = dialog.getValue();
                                    GraphDebugger.this.session.asyncRequest((Write)new WriteRequest(){

                                        public void perform(WriteGraph g) throws DatabaseException {
                                            modifier.modify(g, (Object)value);
                                        }
                                    }, (Callback)new Callback<DatabaseException>(){

                                        public void run(DatabaseException parameter) {
                                            if (parameter != null) {
                                                ErrorLogger.defaultLogError((Throwable)parameter);
                                            }
                                            GraphDebugger.this.refreshBrowser();
                                        }
                                    });
                                }
                            });
                        }
                    }, (Procedure)new ProcedureAdapter<Object>(){

                        public void exception(Throwable t) {
                            ErrorLogger.defaultLogError((Throwable)t);
                        }
                    });
                }
            }
        });
        this.refreshBrowser();
        GraphChangeListenerSupport support = (GraphChangeListenerSupport)this.session.getService(GraphChangeListenerSupport.class);
        support.removeListener(this.changeListener);
        return this.browser;
    }

    public void refreshBrowser() {
        if (this.currentElement == null) {
            return;
        }
        this.updater.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                GraphDebugger.this.updateContent(graph, GraphDebugger.this.currentElement);
            }
        });
    }

    public Resource getDebuggerLocation() {
        return this.currentElement;
    }

    public void changeLocation(Resource element) {
        if (this.currentElement != null) {
            this.backHistory.addLast(this.currentElement);
        }
        this.currentElement = element;
        this.forwardHistory.clear();
        this.refreshBrowser();
        this.setStatus(DONT_TOUCH, null);
        this.fireHistoryChanged();
    }

    public void addHistoryListener(HistoryListener l) {
        this.historyListeners.add(l);
    }

    public void removeHistoryListener(HistoryListener l) {
        this.historyListeners.remove(l);
    }

    private void fireHistoryChanged() {
        for (HistoryListener l : this.historyListeners) {
            l.historyChanged();
        }
    }

    public boolean hasBackHistory() {
        return this.backHistory.isEmpty();
    }

    public boolean hasForwardHistory() {
        return this.forwardHistory.isEmpty();
    }

    public void back() {
        if (this.backHistory.isEmpty()) {
            return;
        }
        this.forwardHistory.addFirst(this.currentElement);
        this.currentElement = this.backHistory.removeLast();
        this.refreshBrowser();
        this.fireHistoryChanged();
    }

    public void forward() {
        if (this.forwardHistory.isEmpty()) {
            return;
        }
        this.backHistory.addLast(this.currentElement);
        this.currentElement = this.forwardHistory.removeFirst();
        this.refreshBrowser();
        this.fireHistoryChanged();
    }

    protected String toName(Object o) {
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            int length = Array.getLength(o);
            if (length > RESOURCE_NAME_MAX_LENGTH) {
                if (o instanceof byte[]) {
                    byte[] arr = (byte[])o;
                    byte[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("byte", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof int[]) {
                    int[] arr = (int[])o;
                    int[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("int", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof long[]) {
                    long[] arr = (long[])o;
                    long[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("long", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof float[]) {
                    float[] arr = (float[])o;
                    float[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("float", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof double[]) {
                    double[] arr = (double[])o;
                    double[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("double", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof boolean[]) {
                    boolean[] arr = (boolean[])o;
                    boolean[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("boolean", Arrays.toString(arr2), arr.length);
                }
                if (o instanceof Object[]) {
                    Object[] arr = (Object[])o;
                    Object[] arr2 = Arrays.copyOf(arr, RESOURCE_NAME_MAX_LENGTH);
                    return this.truncated("Object", Arrays.toString(arr2), arr.length);
                }
                return "Unknown big array " + o.getClass();
            }
            return o.getClass().getComponentType() + "[" + length + "] = " + ObjectUtils.toString((Object)o);
        }
        return null;
    }

    protected String truncated(String type, String string, int originalLength) {
        return String.valueOf(type) + "[" + RESOURCE_NAME_MAX_LENGTH + "/" + originalLength + "] = " + string;
    }

    public static String htmlEscape(String s) {
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br/>");
    }

    protected String getResourceName(ReadGraph graph, Resource r) {
        try {
            String name = null;
            if (graph.hasValue(r)) {
                Datatype type = (Datatype)graph.getPossibleRelatedValue(r, this.L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                if (type != null) {
                    Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
                    if (type.equals((Object)rviBinding.type())) {
                        RVI rvi = (RVI)graph.getValue(r, rviBinding);
                        try {
                            Variable v = Variables.getConfigurationContext((ReadGraph)graph, (Resource)this.currentElement);
                            name = rvi.asString(graph, v);
                        }
                        catch (DatabaseException databaseException) {
                            name = rvi.toString(graph);
                        }
                    } else {
                        long valueSize = NameUtils.getPossibleValueSize((ReadGraph)graph, (Resource)r);
                        if (valueSize > (long)RESOURCE_NAME_MAX_LENGTH) {
                            name = "Approx. " + valueSize + " byte literal of type " + type.toSingleLineString();
                        } else {
                            Binding b = Bindings.getBinding((Datatype)type);
                            Object v = graph.getValue(r, b);
                            name = b.type() instanceof StringType ? (String)graph.getValue(r, b) : b.toString(v, false);
                            if (type instanceof ArrayType) {
                                name = name.substring(1, name.length() - 1);
                            }
                        }
                    }
                } else {
                    Object o = graph.getValue(r);
                    name = this.toName(o);
                }
                if (name.isEmpty()) {
                    name = "<empty value>";
                }
            }
            if (name == null && (name = DebugUtils.getSafeLabel(graph, r)).isEmpty()) {
                name = "<empty name>";
            }
            return name;
        }
        catch (AdaptionException adaptionException) {
            String name = GraphDebugger.safeReadableString(graph, r);
            return name;
        }
        catch (Exception e) {
            ErrorLogger.defaultLogError((Throwable)e);
            String name = GraphDebugger.safeReadableString(graph, r);
            return name;
        }
    }

    private String getResourceRef(ReadGraph graph, Resource r) throws DatabaseException {
        String name;
        try {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            if (graph.isInstanceOf(r, L0.Assertion)) {
                Resource pred = graph.getSingleObject(r, L0.HasPredicate);
                Resource obj = graph.getPossibleObject(r, L0.HasObject);
                String tmp = GraphDebugger.htmlEscape(String.valueOf(this.getResourceName(graph, pred)) + " -> " + (obj == null ? "No object ?" : this.getResourceName(graph, obj)) + " (Assertion)");
                name = tmp.substring(0, Math.min(80, tmp.length()));
            } else {
                Resource inverse;
                String resourceName = this.getResourceName(graph, r);
                if (resourceName.equals("Inverse") && (inverse = graph.getPossibleInverse(r)) != null && graph.hasStatement(inverse, L0.ConsistsOf, r)) {
                    resourceName = String.valueOf(this.getResourceName(graph, inverse)) + "/Inverse";
                }
                String tmp = GraphDebugger.htmlEscape(resourceName);
                name = tmp.substring(0, Math.min(80, tmp.length()));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            name = "OutOfMemoryError";
        }
        String ret = "<a href=\"simantics:browser-link" + this.getLinkString((Container<Resource>)r) + "\">" + name + "</a>";
        if (graph.isInstanceOf(r, this.L0.Literal)) {
            ret = String.valueOf(ret) + "&nbsp;<a class=\"edit-link\" href=\"simantics:browser-edit-value" + this.getLinkString((Container<Resource>)r) + "\">" + "(edit)" + "</a>";
        }
        return ret;
    }

    private String getStatementRemoveRef(Resource s, Resource p, Resource o) {
        return "<a href=\"simantics:browser-remove" + this.getStatementString(s, p, o) + "\" title=\"Remove this statement\">X</a>";
    }

    private void updatePred(StringBuffer content, ReadGraph graph, Resource subj, Resource pred, List<Resource[]> stats) throws DatabaseException {
        String[][] objects = new String[stats.size()][];
        int i = 0;
        while (i < stats.size()) {
            Resource stmSubject = stats.get(i)[0];
            Resource object = stats.get(i)[1];
            objects[i] = new String[4];
            objects[i][0] = this.getLinkString((Container<Resource>)object);
            objects[i][1] = GraphDebugger.htmlEscape(this.getResourceName(graph, object));
            objects[i][2] = this.getResourceRef(graph, object);
            if (!stmSubject.equals(subj)) {
                objects[i][3] = " (in " + this.getResourceRef(graph, stmSubject) + ")";
            }
            ++i;
        }
        Arrays.sort(objects, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)o1[1], (Object)o2[1]);
            }
        });
        i = 0;
        while (i < objects.length) {
            content.append("<tr>");
            if (i == 0) {
                content.append("<td rowspan=\"").append(objects.length).append("\" valign=\"top\">").append(this.getResourceRef(graph, pred)).append("</td>");
            }
            if (objects[i][3] == null) {
                content.append("<td>");
            } else {
                content.append("<td class=\"acquired\">");
            }
            content.append(objects[i][2]);
            if (objects[i][3] != null) {
                content.append(objects[i][3]);
            }
            content.append("</td>");
            VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
            VirtualGraph vg = vgs.getGraph(graph, subj, pred, (Resource)this.links.getRight((Object)objects[i][0]));
            if (vg != null) {
                content.append("<td>").append(vg.toString()).append("</td>");
            } else {
                content.append("<td>DB</td>");
            }
            if (objects[i][3] == null) {
                content.append("<td class=\"remove\">");
                content.append(this.getStatementRemoveRef(subj, pred, (Resource)this.links.getRight((Object)objects[i][0])));
                content.append("</td>");
            }
            content.append("</tr>");
            ++i;
        }
    }

    private void updateTag(StringBuffer content, ReadGraph graph, Resource subj, Resource tag) throws DatabaseException {
        String ref = this.getResourceRef(graph, tag);
        content.append("<tr>");
        content.append("<td rowspan=\"1\" colspan=\"3\" valign=\"top\">").append(ref).append("</td>");
        content.append("<td class=\"remove\">");
        content.append(this.getStatementRemoveRef(subj, tag, subj));
        content.append("</td>");
        content.append("</tr>");
    }

    /*
     * Unable to fully structure code
     */
    private void updateOrderedSet(StringBuffer content, ReadGraph graph, Resource subj) throws DatabaseException {
        list = new ArrayList<String>();
        cur = subj;
        block2: while (true) {
            block7: {
                try {
                    cur = OrderedSetUtils.next((ReadGraph)graph, (Resource)subj, (Resource)cur);
                    break block7;
                }
                catch (DatabaseException e) {
                    list.add("<span style=\"color:red;font-weight:bold\">BROKEN ORDERED SET:<br/></span><span style=\"color:red\">" + e.getMessage() + "</span>");
                    inv = graph.getPossibleInverse(subj);
                    ** for (stat : graph.getStatements((Resource)cur, (Resource)this.L0.IsRelatedTo))
                }
lbl-1000:
                // 1 sources

                {
                    if (!stat.getSubject().equals(cur)) continue;
                    if (stat.getPredicate().equals(subj)) {
                        list.add("next " + this.getResourceRef(graph, stat.getObject()));
                        continue;
                    }
                    if (!stat.getPredicate().equals(inv)) continue;
                    list.add("prev " + this.getResourceRef(graph, stat.getObject()));
                    continue;
lbl21:
                    // 1 sources

                    break block2;
                }
            }
            if (cur.equals(subj)) break;
            list.add(this.getResourceRef(graph, cur));
        }
        i = 0;
        while (i < list.size()) {
            content.append("<tr>");
            if (i == 0) {
                content.append("<td rowspan=\"").append(list.size()).append("\" valign=\"top\">Ordered Set Elements</td>");
            }
            content.append("<td>");
            content.append((String)list.get(i));
            content.append("</td>");
            content.append("</tr>");
            ++i;
        }
    }

    private void updateLinkedList(StringBuffer content, ReadGraph graph, Resource subj) throws DatabaseException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List resources = ListUtils.toList((ReadGraph)graph, (Resource)subj);
            for (Resource element : resources) {
                list.add(this.getResourceRef(graph, element));
            }
        }
        catch (DatabaseException e) {
            throw new ValidationException((Throwable)e);
        }
        int i = 0;
        while (i < list.size()) {
            content.append("<tr>");
            if (i == 0) {
                content.append("<td rowspan=\"").append(list.size()).append("\" valign=\"top\">Linked List Elements</td>");
            }
            content.append("<td>");
            content.append((String)list.get(i));
            content.append("</td><td>DB</td>");
            content.append("</tr>");
            ++i;
        }
    }

    protected synchronized void updateContent(ReadGraph graph, Resource ... resources) throws DatabaseException {
        this.L0 = Layer0.getInstance((ReadGraph)graph);
        this.links.clear();
        StringBuffer content = new StringBuffer();
        content.append("<html>\n<head>\n").append(this.getHead()).append("\n</head>\n").append("<body>\n").append("<div id=\"mainContent\">\n\n");
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (r != null) {
                String uri = null;
                try {
                    uri = (String)graph.syncRequest((Read)new ResourceToPossibleURI(r));
                }
                catch (Exception e) {
                    ErrorLogger.defaultLogError((Throwable)e);
                    uri = "Cannot get URI: " + e.getMessage();
                }
                content.append("<div id=\"top\">\n");
                content.append("<table class=\"top\">\n");
                if (uri != null) {
                    content.append("<tr><td class=\"top_key\">URI</td><td class=\"top_value\"><span id=\"uri\">").append(uri).append("</span></td></tr>\n");
                }
                XSupport xs = (XSupport)graph.getService(XSupport.class);
                boolean immutable = xs.getImmutable(r);
                Collection statements = graph.getStatements(r, this.L0.IsWeaklyRelatedTo);
                HashMultiMap<Resource, Resource[]> map = new HashMultiMap<Resource, Resource[]>();
                for (Statement statement : statements) {
                    Resource predicate = null;
                    Resource subject = null;
                    Resource obj = null;
                    try {
                        predicate = statement.getPredicate();
                        subject = statement.getSubject();
                        obj = statement.getObject();
                        map.add(predicate, new Resource[]{subject, obj});
                    }
                    catch (Throwable e) {
                        ErrorLogger.defaultLogError((String)("Cannot find statement " + subject + " " + predicate + " " + obj), (Throwable)e);
                    }
                }
                SerialisationSupport ss = (SerialisationSupport)graph.getSession().getService(SerialisationSupport.class);
                ClusteringSupport support = (ClusteringSupport)graph.getSession().getService(ClusteringSupport.class);
                content.append("<tr><td class=\"top_key\">Identifiers</td><td class=\"top_value\">");
                content.append("<span id=\"resource_id\">").append(" RID = $").append(r.getResourceId()).append(" Resource Key = ").append(ss.getTransientId(r)).append(" CID = ").append(support.getCluster(r));
                content.append("</span></td>");
                if (immutable) {
                    content.append("<td class=\"remove\">[IMMUTABLE]</td>");
                }
                content.append("</tr>\n");
                boolean isClusterSet = support.isClusterSet(r);
                Resource parentSet = support.getClusterSetOfCluster(r);
                String parentSetURI = parentSet != null ? graph.getPossibleURI(parentSet) : null;
                content.append("<tr><td class=\"top_key\">Clustering</td><td class=\"top_value\">");
                content.append("<span id=\"resource_id\">");
                if (parentSetURI != null) {
                    content.append(" Containing cluster set = ").append(parentSetURI);
                } else if (parentSet != null) {
                    content.append(" Containing cluster set = ").append(parentSet.toString());
                } else {
                    content.append(" Not in any cluster set ");
                }
                content.append("</span></td>");
                if (isClusterSet) {
                    content.append("<td class=\"remove\">[CLUSTER SET]</td>");
                }
                content.append("</tr>\n");
                String resourceValue = this.getResourceValue(graph, r);
                if (resourceValue != null) {
                    content.append("<tr><td class=\"top_key\">Attached value</td><td class=\"top_value\">").append(GraphDebugger.htmlEscape(resourceValue)).append("</td></tr>\n");
                }
                content.append("</table>\n");
                content.append("</div>\n");
                content.append("\n<div id=\"data\">\n");
                content.append("<table>\n").append("<tr><th>Predicate</th><th>Object</th><th>Graph</th></tr>").append("<tr><td class=\"subtitle\" colspan=\"3\">Basic information</td></tr>");
                boolean isOrderedSet = graph.isInstanceOf(r, this.L0.OrderedSet);
                boolean isLinkedList = graph.isInstanceOf(r, this.L0.List);
                Resource[] resourceArray2 = new Resource[]{this.L0.HasName, this.L0.InstanceOf, this.L0.Inherits, this.L0.SubrelationOf, this.L0.PartOf, this.L0.ConsistsOf};
                int n3 = resourceArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Resource pred = resourceArray2[n4];
                    if (map.containsKey(pred)) {
                        this.updatePred(content, graph, r, pred, (List)map.remove(pred));
                    }
                    ++n4;
                }
                content.append("<tr><td class=\"subtitle\" colspan=\"3\">Tags</td></tr>");
                for (Statement stm : statements) {
                    if (!stm.getSubject().equals(stm.getObject())) continue;
                    this.updateTag(content, graph, r, stm.getPredicate());
                    map.remove(stm.getPredicate());
                }
                content.append("<tr><td class=\"subtitle\" colspan=\"3\">Ordered Sets</td></tr>");
                for (Statement stm : statements) {
                    Resource inverse;
                    Resource predicate = stm.getPredicate();
                    if (graph.isInstanceOf(stm.getPredicate(), this.L0.OrderedSet)) {
                        this.updateTag(content, graph, r, stm.getPredicate());
                        if (map.get(stm.getPredicate()) != null && ((List)map.get(stm.getPredicate())).size() == 1) {
                            map.remove(stm.getPredicate());
                        }
                    }
                    if ((inverse = graph.getPossibleInverse(predicate)) == null || !graph.isInstanceOf(inverse, this.L0.OrderedSet) || map.get(stm.getPredicate()) == null || ((List)map.get(stm.getPredicate())).size() != 1) continue;
                    map.remove(stm.getPredicate());
                }
                content.append("<tr><td class=\"subtitle\" colspan=\"3\">Is Related To</td></tr>");
                if (isOrderedSet) {
                    try {
                        this.updateOrderedSet(content, graph, r);
                    }
                    catch (ValidationException e) {
                        content.append("<td colspan=\"3\"><span style=\"color:red;font-weight:bold\">BROKEN ORDERED SET:<br/></span><span style=\"color:red\">").append(e.getMessage()).append("</span></td>");
                    }
                }
                if (isLinkedList) {
                    try {
                        this.updateLinkedList(content, graph, r);
                    }
                    catch (ValidationException e) {
                        content.append("<td colspan=\"3\"><span style=\"color:red;font-weight:bold\">BROKEN LINKED LIST:<br/></span><span style=\"color:red\">").append(e.getMessage()).append("</span></td>");
                    }
                }
                Resource[] preds = map.keySet().toArray(new Resource[0]);
                final HashMap<Resource, String> strmap = new HashMap<Resource, String>(preds.length);
                Resource[] resourceArray3 = preds;
                int n5 = preds.length;
                int n6 = 0;
                while (n6 < n5) {
                    Resource pred = resourceArray3[n6];
                    String str = GraphDebugger.htmlEscape(this.getResourceName(graph, pred));
                    if (str == null) {
                        str = "<null>";
                    }
                    strmap.put(pred, str);
                    ++n6;
                }
                Arrays.sort(preds, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(strmap.get(o1), strmap.get(o2));
                    }
                });
                resourceArray3 = preds;
                n5 = preds.length;
                n6 = 0;
                while (n6 < n5) {
                    Resource pred = resourceArray3[n6];
                    if (graph.isSubrelationOf(pred, this.L0.IsRelatedTo)) {
                        this.updatePred(content, graph, r, pred, (List)map.get(pred));
                    }
                    ++n6;
                }
                content.append("<tr><td class=\"subtitle\" colspan=\"3\">Other statements</td></tr>");
                resourceArray3 = preds;
                n5 = preds.length;
                n6 = 0;
                while (n6 < n5) {
                    Resource pred = resourceArray3[n6];
                    if (!graph.isSubrelationOf(pred, this.L0.IsRelatedTo)) {
                        this.updatePred(content, graph, r, pred, (List)map.get(pred));
                    }
                    ++n6;
                }
                content.append("</table>\n");
            }
            ++n2;
        }
        content.append("</div>\n\n");
        content.append("</div>\n");
        content.append("</body>\n</html>\n");
        final String finalContent = content.toString();
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!GraphDebugger.this.browser.isDisposed()) {
                        GraphDebugger.this.browser.setText(finalContent);
                    }
                }
            });
        }
    }

    private String getResourceValue(ReadGraph graph, Resource r) {
        try {
            if (graph.hasValue(r)) {
                Datatype type = (Datatype)graph.getPossibleRelatedValue(r, this.L0.HasDataType, Bindings.getBindingUnchecked(Datatype.class));
                if (type != null) {
                    Binding rviBinding = ((Databoard)graph.getService(Databoard.class)).getBindingUnchecked(RVI.class);
                    if (type.equals((Object)rviBinding.type())) {
                        RVI rvi = (RVI)graph.getValue(r, rviBinding);
                        try {
                            Variable v = Variables.getConfigurationContext((ReadGraph)graph, (Resource)r);
                            return rvi.asString(graph, v);
                        }
                        catch (DatabaseException databaseException) {
                            return rvi.toString(graph);
                        }
                    }
                    Binding b = Bindings.getBinding((Datatype)type);
                    Object v = graph.getValue(r, b);
                    Serializer s = Bindings.getSerializerUnchecked((Binding)b);
                    int size = s.getSize(v);
                    if (size > RESOURCE_VALUE_MAX_SIZE) {
                        return "Approx. " + size + " byte literal of type " + type.toSingleLineString();
                    }
                    return b.toString(v, false);
                }
                Object o = graph.getValue(r);
                return this.toName(o);
            }
            return null;
        }
        catch (DatabaseException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (BindingException e) {
            return e.getMessage();
        }
    }

    private static String safeReadableString(ReadGraph g, Resource r) {
        try {
            return NameUtils.getSafeName((ReadGraph)g, (Resource)r);
        }
        catch (Throwable throwable) {
            ErrorLogger.defaultLogError((Throwable)throwable);
            return "<font color=\"red\"><i>" + throwable.getClass().getName() + "</i> " + throwable.getMessage() + "</font>";
        }
    }

    private String getLinkString(Container<Resource> t) {
        String link = (String)this.links.getLeft((Object)((Resource)t.get()));
        if (link == null) {
            link = UUID.randomUUID().toString();
            this.links.map((Object)link, (Object)((Resource)t.get()));
        }
        return link;
    }

    private String getStatementString(Resource _s, Resource _p, Resource _o) {
        String s = this.getLinkString((Container<Resource>)_s);
        String p = this.getLinkString((Container<Resource>)_p);
        String o = this.getLinkString((Container<Resource>)_o);
        return String.valueOf(s) + STATEMENT_PART_SEPARATOR + p + STATEMENT_PART_SEPARATOR + o;
    }

    private String getHead() {
        String result = "";
        if (this.cssPath != null) {
            result = "<link href=\"" + this.cssPath + "\" rel=\"stylesheet\" type=\"text/css\">";
        }
        return result;
    }

    public static interface HistoryListener {
        public void historyChanged();
    }
}

