/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.internal;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Hashtable;
import org.eclipse.core.runtime.FileLocator;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.internal.DebugBrowserServer;
import org.simantics.debug.browser.internal.rewriters.BreadcrumbCreator;
import org.simantics.debug.browser.internal.rewriters.PageHeaderCreator;
import org.simantics.debug.browser.internal.rewriters.RawStatementsCreator;
import org.simantics.debug.browser.internal.rewriters.ResourceInfoCreator;
import org.simantics.debug.browser.internal.rewriters.ResourceLookupCreator;
import org.simantics.debug.browser.internal.rewriters.TypeHierarchyCreator;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.simantics.debug.browser";
    private static BundleContext context;
    private static Activator plugin;
    private static String resourcesPath;
    private DebugBrowserServer server;

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        Hashtable properties = new Hashtable();
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)PageHeaderCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)ResourceLookupCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)RawStatementsCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)BreadcrumbCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)TypeHierarchyCreator.INSTANCE, properties);
        bundleContext.registerService(ResourceBrowserRewriter.class, (Object)ResourceInfoCreator.INSTANCE, properties);
        URL url = context.getBundle().getEntry("resources");
        URL fileURL = FileLocator.toFileURL((URL)url);
        File filePath = new File(URLDecoder.decode(fileURL.getPath(), "UTF-8"));
        resourcesPath = filePath.getCanonicalPath();
    }

    public DebugBrowserServer getDebugServer() {
        return this.server;
    }

    public synchronized DebugBrowserServer startDebugServer() throws Exception {
        if (this.server == null) {
            this.server = new DebugBrowserServer(resourcesPath);
            this.server.start();
        }
        return this.server;
    }

    public synchronized void stopDebugServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        this.server = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.stopDebugServer();
        context = null;
    }

    public static Activator getDefault() {
        return plugin;
    }
}

