/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal.rewriters;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.content.ResourceBrowserContent;
import org.simantics.debug.browser.content.ResourceBrowserRewriter;
import org.simantics.debug.browser.sections.ResourceLookupSection;

/**
 * @author Jani Simomaa / Semantum Oy
 * @since 1.22
 */
public enum ResourceLookupCreator implements ResourceBrowserRewriter {
    INSTANCE;

    private ResourceLookupSection lookupSection;
    
    ResourceLookupCreator() {
        lookupSection = new ResourceLookupSection();
    }
    
    @Override
    public double getPriority() {
        return lookupSection.getPriority();
    }

    @Override
    public void rewrite(ReadGraph graph, ResourceBrowserContent content) throws DatabaseException {
        content.putSection(ResourceLookupSection.class, lookupSection);
    }
}
