/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.management.discovery;

import java.net.InetSocketAddress;

public final class InetAddressUtils {
    public static InetSocketAddress parse(String hostAndPort) throws IllegalArgumentException {
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        return new InetSocketAddress(split[0], Integer.parseInt(split[1]));
    }

    public static InetSocketAddress parseUnresolved(String hostAndPort) throws IllegalArgumentException {
        String[] split = hostAndPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address does not contain a port, missing ':' character");
        }
        return InetSocketAddress.createUnresolved(split[0], Integer.parseInt(split[1]));
    }

    public static String toHostString(InetSocketAddress address) {
        if (address == null) {
            return "null";
        }
        return String.valueOf(address.getHostName()) + ":" + address.getPort();
    }

    public static InetSocketAddress parseHostAddressPort(String hostAddressPort) throws IllegalArgumentException {
        String[] split = hostAddressPort.split(":");
        if (split.length != 2) {
            throw new IllegalArgumentException("address not in format '[<host>/]<address>:port', does not contain a port, missing ':' character: " + hostAddressPort);
        }
        String[] split2 = split[0].split("/");
        if (split2.length == 1) {
            return new InetSocketAddress(split[0], Integer.parseInt(split[1]));
        }
        if (split2.length == 2) {
            return new InetSocketAddress(split2[1], Integer.parseInt(split[1]));
        }
        throw new IllegalArgumentException("expected address in format '[<host>/]<address>:port', got " + hostAddressPort);
    }

    public static void main(String[] args) {
        System.out.println(InetAddressUtils.parseHostAddressPort("/127.0.0.1:1234"));
        System.out.println(InetAddressUtils.parseHostAddressPort("localhost/127.0.0.1:1234"));
        System.out.println(InetAddressUtils.parseHostAddressPort("127.0.0.1:1234"));
        System.out.println(InetAddressUtils.parseHostAddressPort("localhost:1234"));
    }
}

