package org.simantics.datatypes.literal;

import org.simantics.common.color.Color;
import org.simantics.common.utils.CommonUtils;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;


public class RGB {

	public static class Integer extends Bean implements Color {
	
        private static final long serialVersionUID = -8574259779076550543L;

        public static final Binding BINDING = Bindings.getBindingUnchecked(Integer.class);
		
		public int red;
		public int green;
		public int blue;
		
		public Integer(int r, int g, int b) {
			super(BINDING);
			this.red = r; this.green = g; this.blue = b;
		}
		
		@Override
		public String toString() {
			return "RGB.Integer[r=" + red + " ,g=" + green + " ,b=" + blue + "]";
		}

		@Override
		public double getR() {
			return CommonUtils.convertColor256ToDouble(red);
		}

		@Override
		public double getG() {
			return CommonUtils.convertColor256ToDouble(green);
		}

		@Override
		public double getB() {
			return CommonUtils.convertColor256ToDouble(blue);
		}

		@Override
		public double getA() {
			return 0;
		}

		@Override
		public double getH() {
			throw new UnsupportedOperationException();
		}

		@Override
		public double getS() {
			throw new UnsupportedOperationException();
		}

		@Override
		public double getV() {
			throw new UnsupportedOperationException();
		}
		
	}
	
}
