/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.compressions.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

/**
 * @author Tuukka Lehtonen
 */
public class Channels {

    public static int read(ReadableByteChannel channel, ByteBuffer intoBuffer, int expectedBytes) throws IOException {
        int read = 0;
        while (read < expectedBytes) {
            int ret = channel.read(intoBuffer);
            if (ret < 0)
                return read; // End-Of-Stream
            read += ret;
        }
        return read;
    }

    public static int read(ReadableByteChannel channel, ByteBuffer intoBuffer) throws IOException {
        return read(channel, intoBuffer, intoBuffer.limit());
    }

    public static int readStream(InputStream stream, byte[] array, int expectedBytes) throws IOException {
        int read = 0;
        while (read < expectedBytes) {
            int ret = stream.read(array, read, expectedBytes - read);
            if (ret < 0)
                return read; // End-Of-Stream
            read += ret;
        }
        return read;
    }

}