/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.ui;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.charts.internal.JsonUtils;
import org.simantics.charts.ui.AddVariableToChartAction;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.PropertyVariables;
import org.simantics.modeling.PropertyVariablesImpl;
import org.simantics.modeling.utils.VariableReferences;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class SubscriptionDropActionFactory
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        Optional<Variable> v;
        Resource subscription = (Resource)ISelectionUtils.getSinglePossibleKey((Object)target, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (subscription == null) {
            return null;
        }
        Resource targetModel = (Resource)g.syncRequest((Read)new PossibleModel(subscription));
        if (source instanceof RVI) {
            RVI rvi = (RVI)source;
            List<VariableReference> refs = Collections.singletonList(new VariableReference(rvi, SubscriptionDropActionFactory.getDatatype(g, targetModel, rvi), null));
            return this.addSubscriptions(g, subscription, refs, Collections.emptySet());
        }
        List vars = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, PropertyVariables.class);
        if (!vars.isEmpty()) {
            List references = (List)g.syncRequest(VariableReferences.toReferences((Resource)targetModel, (List)(vars = PropertyVariablesImpl.resolve((ReadGraph)g, (List)vars))));
            if (!references.isEmpty()) {
                return this.addSubscriptions(g, subscription, references, Collections.emptySet());
            }
        } else {
            List srcs = ISelectionUtils.getPossibleKeys((Object)source, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
            ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
            HashSet<Resource> movedItems = new HashSet<Resource>();
            for (Resource src : srcs) {
                Resource model;
                if (!g.isInstanceOf(src, MOD.Subscription_Item) || !ObjectUtils.objectEquals((Object)targetModel, (Object)(model = (Resource)g.syncRequest((Read)new PossibleModel(src))))) continue;
                movedItems.add(src);
            }
            if (!movedItems.isEmpty()) {
                return this.addSubscriptions(g, subscription, Collections.emptyList(), movedItems);
            }
        }
        if (source instanceof String && (v = JsonUtils.tryParseJsonPropertyVariable(g, (String)source)).isPresent()) {
            List references = (List)g.syncRequest(VariableReferences.variablesToReferences((Resource)targetModel, Collections.singletonList(v.get())));
            return this.addSubscriptions(g, subscription, references, Collections.emptySet());
        }
        return null;
    }

    private Runnable addSubscriptions(ReadGraph graph, final Resource subscription, List<VariableReference> references, final Set<Resource> movedSubscriptionItems) throws DatabaseException {
        AddVariableToChartAction action = new AddVariableToChartAction(null, subscription, references).init(graph);
        return () -> {
            action.run();
            if (!movedSubscriptionItems.isEmpty()) {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        for (Resource item : movedSubscriptionItems) {
                            graph.deny(item, L0.PartOf);
                            graph.claim(subscription, L0.ConsistsOf, item);
                        }
                    }
                }, e -> {
                    if (e != null) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                });
            }
        };
    }

    static Datatype getDatatype(ReadGraph graph, Resource resource, RVI rvi) throws DatabaseException {
        Variable configuration = Variables.getConfigurationContext((ReadGraph)graph, (Resource)resource);
        Variable active = (Variable)graph.syncRequest((Read)new PossibleActiveVariableFromVariable(configuration));
        Variable var = rvi.resolve(graph, active != null ? active : configuration);
        return var.getDatatype(graph);
    }
}

