/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Triple;

/**
 * @author Antti Villberg
 */
public class StringPropertyFactory extends ReadFactoryImpl<Resource, String> {

    private final String propertyURI;
    private final String defaultValue;

    public StringPropertyFactory(String propertyURI) {
        this(propertyURI, null);
    }

    public StringPropertyFactory(String propertyURI, String defaultValue) {
        this.propertyURI = propertyURI;
        this.defaultValue = defaultValue;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Triple<Resource, String, Object>((Resource) inputContents, propertyURI, getClass());
    }

    @Override
    public String perform(ReadGraph graph, Resource resource) throws DatabaseException {
        String value = graph.getPossibleRelatedValue(resource, graph.getResource(propertyURI));
        return value != null ? value : defaultValue;
    }

}
