/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.scl.compiler.StandardSCLCompilerConfiguration;
import org.simantics.scl.ui.editor.SCLTextEditor;
import org.simantics.utils.ui.SWTUtils;

public class SCLEditor extends WidgetImpl {

	private ReadFactory<?, String> textFactory;
	
	final private SCLTextEditor editor;
	
	public SCLEditor(Composite parent, WidgetSupport support, int style) {
		super(support);
		editor = new SCLTextEditor(parent, style, StandardSCLCompilerConfiguration.INSTANCE);
		support.register(this);
	}
	
	public void setTextFactory(ReadFactory<?, String> textFactory) {
		this.textFactory = textFactory;
	}
	
	public SCLTextEditor getWidget() {
		return editor;
	}
	
	@Override
	public Control getControl() {
		return editor;
	}

	@Override
	public void setInput(ISessionContext context, Object input) {

		if(textFactory != null) {
			textFactory.listen(context, input, new Listener<String>() {

				public void exception(final Throwable t) {
					SWTUtils.asyncExec(editor, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
//							System.out.println("Button received new text: " + text);
							editor.setContent(t.toString());
						}

					});
				}

				@Override
				public void execute(final String s) {
					SWTUtils.asyncExec(editor, new Runnable() {

						@Override
						public void run() {
							if(isDisposed()) return;
							editor.setContent(s);
						}

					});
				}

				@Override
				public boolean isDisposed() {
					return editor.isDisposed();
				}

			});
		
		}
		
	}
	
	public void setContent(String s) {
		editor.setContent(s);
	}
	
	public String getContent() {
		return editor.getContent();
	}

}
