package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.simantics.browsing.ui.common.internal.UIElementReference;

public class ViewerRowReference implements UIElementReference{
	
	private final Object element;
	
	public static ViewerRowReference create(ViewerCell cell) {
		return new ViewerRowReference(cell.getViewerRow());
	}
	
	public static ViewerRowReference create(ViewerRow row) {
		return new ViewerRowReference(row);
	}
	
	public static ViewerRowReference create(Object element) {
		return new ViewerRowReference(element);
	}
	
	private ViewerRowReference(ViewerRow row) {
		this.element = row.getElement();
	}
	
	private ViewerRowReference(Object element) {
		this.element = element;
	}
	
	@Override
	public boolean hasReference() {
		return element != null;
	}
	
	@Override
	public boolean isDisposed() {
		if (element == null)
			return true;
		return false;
	}
	
	public Object getElement() {
		return element;
	}
	
	@Override
	public int hashCode() {
		if (element != null)
			return element.hashCode();
		return 0;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj.getClass() != getClass())
			return false;
		if (element == null)
			return false;
		ViewerRowReference other = (ViewerRowReference)obj;
		return element.equals(other.element);
	}
}
