package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ViewerCell;
import org.simantics.browsing.ui.common.internal.UIElementReference;

/**
 * "Reference" to a viewer cell.
 * 
 * ViewerCell is an object, which is not immutable, and has a very short lifespan. Hence we store its element and columnIndex.
 * 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ViewerCellReference implements UIElementReference{
	
	private final Object element;
	private final int column;
	
	public static ViewerCellReference create(ViewerCell cell) {
		return new ViewerCellReference(cell);
	}
	
	private ViewerCellReference(ViewerCell cell) {
		this.element = cell.getElement();
		this.column = cell.getColumnIndex();
	}
	
	@Override
	public boolean hasReference() {
		return element != null;
	}
	
	@Override
	public boolean isDisposed() {
		if (element == null)
			return true;
		return false;
	}
	
	public Object getElement() {
		return element;
	}
	
	public int getColumn() {
		return column;
	}
	
	@Override
	public int hashCode() {
		return element.hashCode() + column;
		
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj.getClass() != getClass())
			return false;
		ViewerCellReference other = (ViewerCellReference)obj;
		if (column != other.column)
			return false;
		return element.equals(other.element);
	}
}
