/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.simantics.db.Resource;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 *
 */
public class ResourceSelectionFilter implements WorkbenchSelectionFilter {

    public static final ResourceSelectionFilter FILTER = new ResourceSelectionFilter();

    @Override
    public ISelection filterSelection(IWorkbenchPart part, ISelection s) {
        // Nevermind the part, just check that the selection contains nothing
        // but resources.
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection) s;
            if (ss.isEmpty())
                return null;

            Resource[] resources = ResourceAdaptionUtils.toResources(ss);
            if (resources.length == ss.size()) {
                return s;
            }
        }

        // Not worth passing.
        return null;
    }

}
