/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;


import java.util.function.Consumer;

import org.simantics.db.common.procedure.adapter.ListenerSupport;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ObjectUtils;

/**
 * @author Tuukka Lehtonen
 */
public class PartNameListener extends PartNameProcedure implements Listener<String> {

    private boolean         disposed = false;
    private ListenerSupport support;

    public PartNameListener(Consumer<String> updateCallback) {
        super(updateCallback);
        support = null;
    }

    public PartNameListener(Consumer<String> updateCallback, ListenerSupport support) {
        super(updateCallback);
        this.support = support;
    }

    @Override
    public void exception(Throwable t) {
        if (support != null)
            support.exception(t);
        else
            super.exception(t);
    }

    public void dispose() {
        disposed = true;
    }

    @Override
    public boolean isDisposed() {
        boolean d = disposed || (support != null && support.isDisposed());
        return d;
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hashCode(support) + 31 * ObjectUtils.hashCode(updateCallback);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        PartNameListener other = (PartNameListener) obj;
        return ObjectUtils.objectEquals(support, other.support)
                && ObjectUtils.objectEquals(updateCallback, other.updateCallback);
    }

}
