/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.platform.debug;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.EvaluatorData.EvaluatorTree;
import org.simantics.browsing.ui.common.contributor.FinalRootViewpointContributionContributor;

public class EvaluatorContribution extends FinalRootViewpointContributionContributor<Evaluator> {

    private boolean isEmpty(EvaluatorTree<?> tree) {
        return tree.getAcceptedFactories().isEmpty() && tree.getChildren().isEmpty();
    }

    private void addNonEmpty(Collection<EvaluatorTree<?>> result, EvaluatorTree<?>... trees) {
        for (EvaluatorTree<?> tree : trees)
            if (!isEmpty(tree))
                result.add(tree);
    }

    @Override
    public Collection<?> getContribution(Evaluator input) {
        //return NodeContextUtil.toContextCollectionWithInput(input.getViewpointTree(), input.getLabelerTree(), input.getImagerTree(), input.getLabelDecoratorTree(), input.getComparatorTree());
        Collection<EvaluatorTree<?>> result = new ArrayList<EvaluatorTree<?>>();
        addNonEmpty(result, input.getViewpointTree(), input.getLabelerTree(), input.getLabelDecoratorTree(), input.getImagerTree(), input.getComparableContextTree());
        return result;
    }

    @Override
    public String getViewpointId() {
        return "Evaluators";
    }

}
