/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.content.Imager;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.nattable.ImageTask;
import org.simantics.browsing.ui.nattable.NatTableGraphExplorer;
import org.simantics.browsing.ui.swt.ViewerRowReference;
import org.simantics.utils.datastructures.BijectionMap;

public class TreeNode
implements IAdaptable {
    private static boolean DEBUG = false;
    private NodeContext context;
    GENodeQueryManager manager;
    NatTableGraphExplorer.GeViewerContext explorerContext;
    TreeNode parent;
    List<TreeNode> children = new ArrayList<TreeNode>();
    boolean expanded;
    boolean autoExpanded = false;
    int listIndex = -1;
    private Labeler labeler;
    private Imager imager;
    Collection<LabelDecorator> labelDecorators;
    Collection<ImageDecorator> imageDecorators;
    Map<String, String> labels;
    Map<String, String> runtimeLabels;

    public TreeNode(NodeContext context, NatTableGraphExplorer.GeViewerContext explorerContext) {
        this.context = context;
        this.explorerContext = explorerContext;
        this.expanded = false;
        this.manager = new GENodeQueryManager((IGraphExplorerContext)explorerContext, null, null, (UIElementReference)ViewerRowReference.create((Object)this));
        explorerContext.getContextToNodeMap().add((Object)context, (Object)this);
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    public int getListIndex() {
        return this.listIndex;
    }

    public void setListIndex(int listIndex) {
        this.listIndex = listIndex;
    }

    List<TreeNode> getChildren() {
        return this.children;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isHidden() {
        TreeNode n = this.parent;
        while (n != null) {
            if (!n.isExpanded()) {
                return true;
            }
            n = n.getParent();
        }
        return false;
    }

    public TreeNode getCollapsedAncestor() {
        TreeNode collapsed = null;
        TreeNode n = this.parent;
        while (n != null) {
            if (!n.isExpanded()) {
                collapsed = n;
            }
            n = n.getParent();
        }
        return collapsed;
    }

    public NodeContext getContext() {
        return this.context;
    }

    public String getValueString(int column) {
        if (column == 0) {
            this.initData();
        }
        if (this.labeler != null) {
            String key = this.explorerContext.getGe().getColumns()[column].getKey();
            String s = null;
            if (this.runtimeLabels != null) {
                s = this.runtimeLabels.get(key);
            }
            if (s == null) {
                s = this.labels.get(key);
            }
            if (this.labelDecorators != null && !this.labelDecorators.isEmpty()) {
                int index = 0;
                for (LabelDecorator ld : this.labelDecorators) {
                    String ds = ld.decorateLabel(s, key, index);
                    if (ds == null) continue;
                    s = ds;
                }
            }
            return s;
        }
        return null;
    }

    public Image getImage(int column) {
        String key = this.explorerContext.getGe().getColumns()[column].getKey();
        if (this.imager != null) {
            Object descOrImage = null;
            boolean hasUncachedImages = false;
            ImageDescriptor desc = (ImageDescriptor)this.imager.getImage(key);
            if (desc != null) {
                Object img;
                int index = 0;
                if (!this.imageDecorators.isEmpty()) {
                    for (ImageDecorator id : this.imageDecorators) {
                        ImageDescriptor ds = (ImageDescriptor)id.decorateImage((Object)desc, key, index);
                        if (ds == null) continue;
                        desc = ds;
                    }
                }
                if ((img = this.explorerContext.getGe().localResourceManager.find((DeviceResourceDescriptor)desc)) == null) {
                    img = this.explorerContext.getGe().resourceManager.find((DeviceResourceDescriptor)desc);
                }
                descOrImage = img != null ? img : desc;
                hasUncachedImages |= img == null;
            }
            if (!hasUncachedImages) {
                return (Image)descOrImage;
            }
            this.explorerContext.getGe().queueImageTask(this, new ImageTask(this, descOrImage));
            return null;
        }
        return null;
    }

    public void getStyle(int column, Style style) {
        String key = this.explorerContext.getGe().getColumns()[column].getKey();
        FontDescriptor font = this.explorerContext.getGe().originalFont;
        ColorDescriptor bg = this.explorerContext.getGe().originalBackground;
        ColorDescriptor fg = this.explorerContext.getGe().originalForeground;
        if (this.labelDecorators != null && !this.labelDecorators.isEmpty()) {
            int index = 0;
            for (LabelDecorator ld : this.labelDecorators) {
                ColorDescriptor dfg;
                ColorDescriptor dbg;
                FontDescriptor dfont = (FontDescriptor)ld.decorateFont((Object)font, key, index);
                if (dfont != null) {
                    font = dfont;
                }
                if ((dbg = (ColorDescriptor)ld.decorateBackground((Object)bg, key, index)) != null) {
                    bg = dbg;
                }
                if ((dfg = (ColorDescriptor)ld.decorateForeground((Object)fg, key, index)) == null) continue;
                fg = dfg;
            }
        }
        if (font != this.explorerContext.getGe().originalFont) {
            style.setAttributeValue(CellStyleAttributes.FONT, (Object)((Font)this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)font)));
        } else {
            style.setAttributeValue(CellStyleAttributes.FONT, (Object)((Font)(this.explorerContext.getGe().originalFont != null ? this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)this.explorerContext.getGe().originalFont) : null)));
        }
        if (bg != this.explorerContext.getGe().originalBackground) {
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)((Color)this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)bg)));
        } else {
            style.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)((Color)(this.explorerContext.getGe().originalBackground != null ? this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)this.explorerContext.getGe().originalBackground) : null)));
        }
        if (fg != this.explorerContext.getGe().originalForeground) {
            style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)((Color)this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)fg)));
        } else {
            style.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)((Color)(this.explorerContext.getGe().originalForeground != null ? this.explorerContext.getGe().localResourceManager.get((DeviceResourceDescriptor)this.explorerContext.getGe().originalForeground) : null)));
        }
    }

    public void initData() {
        this.labeler = (Labeler)this.manager.query(this.context, BuiltinKeys.SELECTED_LABELER);
        this.imager = (Imager)this.manager.query(this.context, BuiltinKeys.SELECTED_IMAGER);
        this.labelDecorators = (Collection)this.manager.query(this.context, BuiltinKeys.LABEL_DECORATORS);
        this.imageDecorators = (Collection)this.manager.query(this.context, BuiltinKeys.IMAGE_DECORATORS);
        if (this.labeler != null) {
            this.labels = this.labeler.getLabels();
            this.runtimeLabels = this.labeler.getRuntimeLabels();
        } else {
            this.labels = null;
            this.runtimeLabels = null;
        }
    }

    public TreeNode addChild(NodeContext context, NatTableGraphExplorer.GeViewerContext explorerContext) {
        TreeNode child = new TreeNode(context, explorerContext);
        child.parent = this;
        this.children.add(child);
        if (DEBUG) {
            System.out.println("Add " + this + " -> " + child);
        }
        return child;
    }

    public TreeNode addChild(int index, NodeContext context, NatTableGraphExplorer.GeViewerContext explorerContext) {
        TreeNode child = new TreeNode(context, explorerContext);
        child.parent = this;
        this.children.add(index, child);
        if (DEBUG) {
            System.out.println("Add " + this + " -> " + child + " at " + index);
        }
        return child;
    }

    public TreeNode setChild(int index, NodeContext context, NatTableGraphExplorer.GeViewerContext explorerContext) {
        TreeNode child = new TreeNode(context, explorerContext);
        child.parent = this;
        this.children.set(index, child);
        if (DEBUG) {
            System.out.println("Set " + this + " -> " + child + " at " + index);
        }
        return child;
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.dispose2();
    }

    public void dispose2() {
        if (DEBUG) {
            System.out.println("dispose " + this);
        }
        this.parent = null;
        for (TreeNode n : this.children) {
            n.dispose2();
        }
        this.clearCache();
        this.children.clear();
        this.explorerContext.getContextToNodeMap().remove((Object)this.context, (Object)this);
        this.context = null;
        this.explorerContext = null;
        this.manager.dispose();
        this.manager = null;
    }

    private void clearCache() {
        NatTableGraphExplorer.GECache2 cache;
        if (this.explorerContext != null && (cache = this.explorerContext.cache) != null) {
            cache.dispose(this.context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateChildren() {
        if (this.context == null) {
            throw new IllegalStateException("Node is disposed.");
        }
        NodeContext[] childContexts = (NodeContext[])this.manager.query(this.context, BuiltinKeys.FINAL_CHILDREN);
        if (DEBUG) {
            System.out.println("updateChildren " + childContexts.length + " " + this);
        }
        boolean modified = false;
        List<TreeNode> list = this.children;
        synchronized (list) {
            int oldCount = this.children.size();
            BijectionMap indexes = new BijectionMap();
            HashSet<Integer> mapped = new HashSet<Integer>();
            boolean reorder = false;
            int i = 0;
            while (i < oldCount) {
                NodeContext oldCtx = this.children.get((int)i).context;
                int j = 0;
                while (j < childContexts.length) {
                    if (!mapped.contains(j) && oldCtx.equals(childContexts[j])) {
                        indexes.map((Object)i, (Object)j);
                        mapped.add(j);
                        if (i == j) break;
                        reorder = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            if (childContexts.length != oldCount || reorder || childContexts.length != indexes.size()) {
                TreeNode n;
                int i2;
                modified = true;
                ArrayList<TreeNode> oldChildren = new ArrayList<TreeNode>(oldCount);
                oldChildren.addAll(this.children);
                if (childContexts.length >= oldCount) {
                    i2 = 0;
                    while (i2 < oldCount) {
                        Integer oldIndex = (Integer)indexes.getLeft((Object)i2);
                        if (oldIndex == null) {
                            this.setChild(i2, childContexts[i2], this.explorerContext);
                        } else {
                            n = (TreeNode)oldChildren.get(oldIndex);
                            this.children.set(i2, n);
                        }
                        ++i2;
                    }
                    i2 = oldCount;
                    while (i2 < childContexts.length) {
                        Integer oldIndex = (Integer)indexes.getLeft((Object)i2);
                        if (oldIndex == null) {
                            this.addChild(childContexts[i2], this.explorerContext);
                        } else {
                            n = (TreeNode)oldChildren.get(oldIndex);
                            this.children.add(n);
                        }
                        ++i2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < childContexts.length) {
                        Integer oldIndex = (Integer)indexes.getLeft((Object)i2);
                        if (oldIndex == null) {
                            this.setChild(i2, childContexts[i2], this.explorerContext);
                        } else {
                            n = (TreeNode)oldChildren.get(oldIndex);
                            this.children.set(i2, n);
                        }
                        ++i2;
                    }
                    i2 = oldCount - 1;
                    while (i2 >= childContexts.length) {
                        this.children.remove(i2);
                        --i2;
                    }
                }
                i2 = 0;
                while (i2 < oldChildren.size()) {
                    if (!indexes.containsLeft((Object)i2)) {
                        ((TreeNode)oldChildren.get(i2)).dispose2();
                    }
                    ++i2;
                }
            }
        }
        return modified;
    }

    public boolean isDisposed() {
        return this.context == null;
    }

    public GENodeQueryManager getManager() {
        return this.manager;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == NodeContext.class) {
            return this.context;
        }
        return this.context.getAdapter(adapter);
    }

    public String toString() {
        return "TreeNode: " + this.listIndex + " " + (this.expanded ? "(+)" : "(-)") + " " + this.context;
    }
}

