/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.simantics.browsing.ui.nattable.GETreeData;
import org.simantics.browsing.ui.nattable.RowSelectionItem;
import org.simantics.browsing.ui.nattable.TreeNode;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.ui.AdaptionUtils;

public class NatTableSelectionAdaptor
implements ISelectionProvider,
IPostSelectionProvider,
ILayerListener {
    NatTable natTable;
    SelectionLayer selectionLayer;
    GETreeData treeData;
    StructuredSelection selection;
    private List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    private List<ISelectionChangedListener> postSelectionListeners = new ArrayList<ISelectionChangedListener>();
    private List<SelectionListener> selListeners = new ArrayList<SelectionListener>();
    private List<Point> selectedCells = new ArrayList<Point>();

    public NatTableSelectionAdaptor(NatTable natTable, SelectionLayer selectionLayer, GETreeData treeData) {
        this.natTable = natTable;
        this.selectionLayer = selectionLayer;
        this.natTable.addLayerListener((ILayerListener)this);
        this.treeData = treeData;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postSelectionListeners.remove(listener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        if (!(selection instanceof StructuredSelection)) {
            throw new IllegalArgumentException("Selection must be structured selection");
        }
        if (selection.isEmpty()) {
            this.selectionLayer.clear(false);
            this.natTable.redraw();
            return;
        }
        ArrayList<RowSelectionItem> rowItems = new ArrayList<RowSelectionItem>(AdaptionUtils.adaptToCollection((Object)selection, RowSelectionItem.class));
        if (rowItems.size() > 0) {
            this.setSelectionExternal(rowItems);
            return;
        }
        Collection nodes = AdaptionUtils.adaptToCollection((Object)selection, TreeNode.class);
        if (nodes.size() > 0) {
            ArrayList<RowSelectionItem> selected = new ArrayList<RowSelectionItem>();
            int[] allCols = new int[this.selectionLayer.getColumnCount()];
            int i = 0;
            while (i < allCols.length) {
                allCols[i] = i;
                ++i;
            }
            for (TreeNode n : nodes) {
                selected.add(new RowSelectionItem(n, n.listIndex, allCols));
            }
            this.setSelectionExternal(selected);
            return;
        }
    }

    private void setSelectionExternal(List<RowSelectionItem> items) {
        this.selectionLayer.clear(true);
        for (RowSelectionItem item : items) {
            int[] nArray = item.columnIndex;
            int n = item.columnIndex.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                this.selectionLayer.selectCell(c, item.rowIndex, false, true);
                ++n2;
            }
        }
        this.selection = new StructuredSelection(items);
        this.fireEvents();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof CellSelectionEvent) {
            this.evaluateSeletedCells();
        }
    }

    private void evaluateSeletedCells() {
        this.selectedCells.clear();
        PositionCoordinate[] positionCoordinateArray = this.selectionLayer.getSelectedCellPositions();
        int n = positionCoordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            PositionCoordinate pc = positionCoordinateArray[n2];
            ILayerCell cell = pc.getLayer().getCellByPosition(pc.columnPosition, pc.rowPosition);
            this.selectedCells.add(new Point(cell.getColumnIndex(), cell.getRowIndex()));
            ++n2;
        }
        MapList rowMap = new MapList();
        for (Point p : this.selectedCells) {
            rowMap.add((Object)p.y, (Object)p.x);
        }
        ArrayList<RowSelectionItem> selectionItems = new ArrayList<RowSelectionItem>(rowMap.getKeySize());
        for (Integer row : rowMap.getKeys()) {
            List cols = rowMap.getValues((Object)row);
            int[] col = new int[cols.size()];
            int i = 0;
            while (i < col.length) {
                col[i] = (Integer)cols.get(i);
                ++i;
            }
            selectionItems.add(new RowSelectionItem(this.treeData.getDataAtIndex(row), row, col));
        }
        this.selection = new StructuredSelection(selectionItems);
        this.fireEvents();
    }

    private void fireEvents() {
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        }
        for (ISelectionChangedListener l : this.postSelectionListeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        }
        Event evt = new Event();
        evt.widget = this.natTable;
        evt.display = this.natTable.getDisplay();
        evt.data = this.selection;
        for (SelectionListener l : this.selListeners) {
            SelectionEvent sel = new SelectionEvent(evt);
            l.widgetSelected(sel);
        }
    }

    public List<Point> getSelectedCells() {
        return this.selectedCells;
    }
}

