/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.sorters;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public abstract class AbstractSorter<T> implements Sorter {

    public abstract T getSortingCriterion(ReadGraph graph, BrowseContext context, NodeContext node) throws DatabaseException;
    public abstract int compare(T a, T b);
    
    static class OrderNodeContext<T> {
        public final NodeContext node;
        public final T criterion;
        
        public OrderNodeContext(NodeContext node, T criterion) {        
            this.node = node;
            this.criterion = criterion;
        }
    }
    
    Comparator<OrderNodeContext<T>> comparator = new Comparator<OrderNodeContext<T>>() {
        @Override
        public int compare(OrderNodeContext<T> o1, OrderNodeContext<T> o2) {
            return AbstractSorter.this.compare(o1.criterion, o2.criterion);
        }        
    };
    
    @Override
    public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException {
        @SuppressWarnings("unchecked")
        OrderNodeContext<T>[] orderNodes = new OrderNodeContext[nodes.size()];
        for (int i = 0; i < orderNodes.length; i++) {
            NodeContext node = nodes.get(i);
            orderNodes[i] = new OrderNodeContext<T>(node, getSortingCriterion(graph, context, node));
        }
        Arrays.sort(orderNodes, comparator);
        for (int i = 0; i < orderNodes.length; i++)
            nodes.set(i, orderNodes[i].node);
    }

}
