/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.actions;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class ActionCategory implements IActionCategory {

    Resource resource;
    String label;
    double priority;
    boolean isSubmenu;
    
    public ActionCategory(Resource resource, String label, double priority, boolean isSubmenu) {
        this.resource = resource;
        this.label = label;
        this.priority = priority;
        this.isSubmenu = isSubmenu;
    }

    @Override
    public String getLabel() {
        return label;
    }

    @Override
    public double getPriority() {
        return priority;
    }

    @Override
    public boolean isSubmenu() {
        return isSubmenu;
    }

    public static ActionCategory create(ReadGraph g, Resource r) throws DatabaseException {
        ViewpointResource vr = ViewpointResource.getInstance(g);       
        
        String label = NameUtils.getSafeLabel(g, r);
        
        Resource priorityResource = g.getPossibleObject(r, vr.ActionCategory_HasPriority);
        double priority = priorityResource == null ? 0.0 : (Double)g.getValue(priorityResource, Bindings.DOUBLE);

        Resource isSubmenuResource = g.getPossibleObject(r, vr.ActionCategory_IsSubmenu);
        boolean isSubmenu = isSubmenuResource == null ? false : (Boolean)g.getValue(isSubmenuResource, Bindings.BOOLEAN);
        
        return new ActionCategory(r, label, priority, isSubmenu);
    }
    
    @Override
    public int hashCode() {
        return resource.hashCode();
    }
    
    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null || obj.getClass() != ActionCategory.class)
            return false;
        return resource.equals(((ActionCategory)obj).resource);
    }
}
