/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collections;
import java.util.Map;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.labelers.LabelerContent;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ui.ErrorLogger;

public abstract class LazyGraphLabeler
extends LabelerStub {
    protected final PrimitiveQueryUpdater updater;
    private final ResourceQuery<LabelerContent> labelQuery;
    private final Listener<LabelerContent> procedure;

    public Object getIdentity(BuiltinKeys.LabelerKey key) {
        return key;
    }

    public LazyGraphLabeler(final PrimitiveQueryUpdater updater, final NodeContext context, final BuiltinKeys.LabelerKey key) {
        this.updater = updater;
        this.labelQuery = new ResourceQuery<LabelerContent>(this.getIdentity(key), context){

            public LabelerContent perform(ReadGraph graph) throws DatabaseException {
                try {
                    int cat = LazyGraphLabeler.this.category(graph);
                    Map<String, String> lbls = LazyGraphLabeler.this.labels(graph);
                    if (lbls == null) {
                        throw new NullPointerException("LazyGraphLabeler.labels is not allowed to return null, but " + ((Object)((Object)LazyGraphLabeler.this)).getClass() + " just did it");
                    }
                    return new LabelerContent(cat, lbls);
                }
                catch (DatabaseException e) {
                    throw e;
                }
                catch (Throwable t) {
                    ErrorLogger.defaultLogError((String)"LazyGraphLabeler.labelQuery produced unexpected exception.", (Throwable)t);
                    return LabelerContent.NO_CONTENT;
                }
            }

            public String toString() {
                return (Object)((Object)LazyGraphLabeler.this) + " with context " + this.context;
            }
        };
        this.procedure = new Listener<LabelerContent>(){

            public void execute(LabelerContent result) {
                LazyGraphLabeler.this.setContent(result);
                updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)LazyGraphLabeler.this);
            }

            public boolean isDisposed() {
                return updater.isDisposed();
            }

            public void exception(Throwable t) {
                System.err.println("LazyGraphLabeler2: ");
                t.printStackTrace();
            }
        };
    }

    public Map<String, String> getLabels() {
        if (this.content == LabelerContent.NO_CONTENT) {
            DataSource source = this.updater.getDataSource(ReadGraph.class);
            assert (source != null);
            source.schedule(graph -> graph.asyncRequest(this.labelQuery, this.procedure));
        }
        if (this.content == null) {
            return Collections.emptyMap();
        }
        return this.content.labels;
    }

    public abstract Map<String, String> labels(ReadGraph var1) throws DatabaseException;

    public int category(ReadGraph graph) throws DatabaseException {
        if (this.content == null) {
            return 0;
        }
        return this.content.category;
    }
}

