/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.BuiltinKeys.CheckedStateKey;
import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.graph.impl.request.ResourceQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

public abstract class FinalCheckedStateContributionImpl {

    protected final PrimitiveQueryUpdater       updater;
    private final ResourceQuery<CheckedState> labelQuery;
    private final Procedure<CheckedState>      procedure;

    final private NodeContext                context;
    final private BuiltinKeys.CheckedStateKey    key;
    
    private CheckedState state = null;

    public Object getIdentity(CheckedStateKey key) {
        return key;
    }

    public CheckedState getState() {
    	
    	if (state == null) {

            final DataSource<ReadGraph> source = updater.getDataSource(ReadGraph.class);
            assert(source != null);

            source.schedule(graph -> {
                if(procedure instanceof Listener<?>)
                    graph.asyncRequest(labelQuery, (Listener<CheckedState>)procedure);
                else
                    graph.asyncRequest(labelQuery, procedure);
            });
    		
    	}
    	
    	return state;
    	
    }
    
    public FinalCheckedStateContributionImpl(final PrimitiveQueryUpdater updater, final NodeContext context, final CheckedStateKey key) {

        this.updater = updater;
        this.context = context;
        this.key = key;

        labelQuery = new ResourceQuery<CheckedState>(getIdentity(key), context) {

            @Override
            public CheckedState perform(ReadGraph graph) throws DatabaseException {
                try {
                	return getState(graph, context);
                } catch (DatabaseException e) {
                    throw e;
                } catch (Throwable t) {
                    ErrorLogger.defaultLogError("LazyGraphLabeler.labelQuery produced unexpected exception.", t);
                    return null;
                }
            }

            @Override
            public String toString() {
                return FinalCheckedStateContributionImpl.this + " with context " + context;
            }

        };

        procedure = createProcedure();

    }

    protected Procedure<CheckedState> createProcedure() {

        return new Procedure<CheckedState>() {

            @Override
            public void execute(CheckedState result) {
                replaceResult(result);
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError("LazyContributionImpl.childQuery failed, see exception for details.", t);
            }

        };

    }

    protected void replaceResult(CheckedState result) {
        state = result;
        updater.scheduleReplace(context, key, state);
    }

    abstract public CheckedState getState(ReadGraph graph, NodeContext context) throws DatabaseException;
    

}
