/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl.contribution;

import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.CheckedStateKey;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.Procedure;
import org.simantics.utils.ui.ErrorLogger;

/**
 * 
 * @author Antti Villberg
 */
abstract public class CheckedStateContributionImpl extends FinalCheckedStateContributionImpl {

	public CheckedStateContributionImpl(PrimitiveQueryUpdater updater,
			NodeContext context, CheckedStateKey key) {
		super(updater, context, key);
	}

	@Override
	protected Procedure<CheckedState> createProcedure() {
		
    	return new Listener<CheckedState>() {

            @Override
            public void execute(CheckedState result) {
                replaceResult(result);
            }

            @Override
            public boolean isDisposed() {
                return updater.isDisposed();
            }

            @Override
            public void exception(Throwable t) {
                ErrorLogger.defaultLogError("LazyContributionImpl.childQuery failed, see exception for details.", t);
            }

        };
		
	}

}
