/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelerKey;
import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.common.labelers.LazyContainerLabeler;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.content.LabelerFactory;

public class TypeIndexLabelerFactory implements LabelerFactory {

    @Override
    public Labeler create(PrimitiveQueryUpdater updater, NodeContext context, LabelerKey key) {
        assert updater != null;

        final LazyContainerLabeler result = new LazyContainerLabeler();

        final TypeIndex inputIndex = (TypeIndex) context.getConstant(BuiltinKeys.INPUT);
        assert inputIndex != null;

        result.addLabel(ColumnKeys.SINGLE, inputIndex.name);

        return result;
    }

}
