/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.graph.impl;

import java.util.Collections;
import java.util.Set;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.Container;

public class InheritsQueryProcessor extends LazyGraphQueryProcessor<Set<Resource>> {

    @Override
    public String toString() {
        return "InheritsProcessor";
    }

    @Override
    public Object getIdentifier() {
        return CommonKeys.INHERITS;
    }

    @Override
    protected Set<Resource> initial() {
        return Collections.emptySet();
    }

    @Override
    protected Set<Resource> compute(ReadGraph graph, NodeContext context, PrimitiveQueryKey<Container<Set<Resource>>> key) throws DatabaseException {
        Object input = context.getConstant(BuiltinKeys.INPUT);
        if (input instanceof Resource) {
            return graph.getSupertypes((Resource) input);
        } else if (input instanceof ResourceArray) {
            return graph.getSupertypes(((ResourceArray) input).resources[0]);
        }
        return Collections.emptySet();
    }

}
