/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.internal;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.NodeQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.internal.IGECache;
import org.simantics.browsing.ui.common.internal.IGraphExplorerContext;
import org.simantics.browsing.ui.common.internal.UIElementReference;
import org.simantics.browsing.ui.exception.NoDataSourceException;
import org.simantics.browsing.ui.exception.NoQueryProcessorException;

public class GENodeQueryManager
implements NodeQueryManager,
PrimitiveQueryUpdater {
    private static final boolean DEBUG = false;
    protected IGraphExplorerContext ge;
    protected NodeContext parentContext;
    protected NodeContext.CacheKey<?> parentKey;
    protected UIElementReference treeReference;
    protected boolean disposed = false;
    List<GENodeQueryManager> children = new ArrayList<GENodeQueryManager>();

    void indent() {
        this.ge.queryIndent(1);
    }

    void unindent() {
        this.ge.queryIndent(-1);
    }

    void queryDebug(String s) {
        int i = 0;
        while (i < this.ge.queryIndent()) {
            System.err.append("   ");
            ++i;
        }
        System.err.println(s);
    }

    String toString(UIElementReference ref) {
        return ref == null ? "" : ref.toString();
    }

    String toString(Set<UIElementReference> refs) {
        if (refs == null || refs.isEmpty()) {
            return "{}";
        }
        StringBuilder b = new StringBuilder();
        for (UIElementReference ref : refs) {
            b.append(this.toString(ref));
        }
        return b.toString();
    }

    String toString(NodeContext ctx, NodeContext.CacheKey<?> key) {
        if (ctx == null) {
            return "null";
        }
        Set<UIElementReference> refs = this.ge.getCache().getTreeReference(ctx, key);
        return ctx + this.toString(refs);
    }

    public GENodeQueryManager(GENodeQueryManager parent, NodeContext parentContext, NodeContext.CacheKey<?> parentKey, UIElementReference treeReference) {
        this.ge = parent.ge;
        this.parentContext = parentContext;
        this.parentKey = parentKey;
        this.treeReference = treeReference;
        parent.children.add(this);
    }

    public GENodeQueryManager(IGraphExplorerContext ge, NodeContext parentContext, NodeContext.CacheKey<?> parentKey, UIElementReference treeReference) {
        this.ge = ge;
        this.parentContext = parentContext;
        this.parentKey = parentKey;
        this.treeReference = treeReference;
    }

    public Object getExplorerContext() {
        return this.ge;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.ge != null && this.parentContext != null && this.parentKey != null) {
            this.ge.getCache().remove(this.parentContext, this.parentKey);
        }
        this.ge = null;
        this.parentContext = null;
        this.parentKey = null;
        this.treeReference = null;
        for (GENodeQueryManager m : this.children) {
            m.dispose();
        }
        this.children.clear();
        this.children = null;
    }

    public <T> void replaceResult(NodeContext context, NodeContext.PrimitiveQueryKey<T> key, T newResult, int indent) {
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return;
        }
        IGECache cache = ge.getCache();
        IGECache.IGECacheEntry oldEntry = cache.getEntry(context, key);
        if (oldEntry != null) {
            cache.put(context, key, newResult);
            this.propagate(context, (NodeContext.CacheKey<T>)key, oldEntry, indent);
            Set<UIElementReference> refs = cache.removeTreeReference(context, key);
            if (refs != null) {
                for (UIElementReference ref : refs) {
                    ge.update(ref);
                }
            }
        } else {
            Set<UIElementReference> ref = cache.getTreeReference(context, key);
            assert (ref == null);
        }
    }

    public <T> void clearResult(NodeContext context, NodeContext.CacheKey<T> key, int indent) {
        Set<UIElementReference> refs;
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return;
        }
        IGECache cache = ge.getCache();
        IGECache.IGECacheEntry entry = cache.getEntry(context, key);
        if (entry != null) {
            cache.remove(context, key);
            this.propagate(context, key, entry, indent);
        }
        if ((refs = cache.removeTreeReference(context, key)) != null) {
            for (UIElementReference ref : refs) {
                ge.update(ref);
            }
        }
    }

    public <T> void propagate(NodeContext context, NodeContext.CacheKey<T> key, IGECache.IGECacheEntry entry, int indent) {
        if (this.isDisposed()) {
            return;
        }
        assert (entry != null);
        for (IGECache.IGECacheEntry dependency : entry.getDependencies()) {
            this.clearResult(dependency.getContext(), dependency.getKey(), indent + 3);
        }
        entry.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(NodeContext context, NodeContext.QueryKey<T> key) throws NoQueryProcessorException {
        assert (!this.ge.isDisposed());
        assert (context != this.parentContext || key != this.parentKey);
        assert (context != null);
        assert (key != null);
        Object result = null;
        IGECache cache = this.ge.getCache();
        Object object = this.ge.getPropagateLock();
        synchronized (object) {
            IGECache.IGECacheEntry entry = cache.getEntry(context, key);
            if (entry == null) {
                entry = cache.put(context, key, null);
                NodeQueryProcessor processor = this.ge.getProcessor(key);
                if (processor == null) {
                    throw new NoQueryProcessorException(key);
                }
                Object value = processor.query((NodeQueryManager)new GENodeQueryManager(this, context, (NodeContext.CacheKey<?>)key, null), context);
                entry.setValue(value);
            }
            if (this.treeReference != null) {
                UIElementReference cachedTreeReference = this.treeReference;
                Set<UIElementReference> oldRefs = cache.getTreeReference(context, key);
                if (oldRefs != null) {
                    if (cachedTreeReference.isDisposed()) {
                        oldRefs.remove(cachedTreeReference);
                    } else {
                        cache.putTreeReference(context, key, cachedTreeReference);
                    }
                } else {
                    cache.putTreeReference(context, key, cachedTreeReference);
                }
            }
            if (this.parentContext != null) {
                assert (this.parentKey != null);
                IGECache.IGECacheEntry parentEntry = cache.getEntry(this.parentContext, this.parentKey);
                if (parentEntry != null) {
                    entry.addDependency(parentEntry);
                }
            }
            result = entry.getValue();
        }
        this.unindent();
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(NodeContext context, NodeContext.PrimitiveQueryKey<T> key) throws NoQueryProcessorException {
        assert (!this.ge.isDisposed());
        assert (context != this.parentContext || key != this.parentKey);
        assert (!(this.parentKey instanceof NodeContext.PrimitiveQueryKey));
        assert (context != null);
        assert (key != null);
        Object result = null;
        IGECache cache = this.ge.getCache();
        Object object = this.ge.getPropagateLock();
        synchronized (object) {
            IGECache.IGECacheEntry entry = cache.getEntry(context, key);
            if (entry == null) {
                entry = cache.put(context, key, null);
                PrimitiveQueryProcessor processor = this.ge.getPrimitiveProcessor(key.processorIdenfitier());
                if (processor == null) {
                    throw new NoQueryProcessorException(key);
                }
                Object value = processor.query((PrimitiveQueryUpdater)new GENodeQueryManager(this, context, (NodeContext.CacheKey<?>)key, null), context, key);
                entry.setValue(value);
            }
            if (this.treeReference != null) {
                UIElementReference cachedTreeReference = this.treeReference;
                Set<UIElementReference> oldRefs = cache.getTreeReference(context, key);
                if (oldRefs != null) {
                    if (cachedTreeReference.isDisposed()) {
                        oldRefs.remove(cachedTreeReference);
                    } else {
                        cache.putTreeReference(context, key, cachedTreeReference);
                    }
                } else {
                    cache.putTreeReference(context, key, cachedTreeReference);
                }
            }
            if (this.parentContext != null) {
                assert (this.parentKey != null);
                IGECache.IGECacheEntry parentEntry = cache.getEntry(this.parentContext, this.parentKey);
                if (parentEntry != null) {
                    entry.addDependency(parentEntry);
                }
            }
            result = entry.getValue();
        }
        this.unindent();
        return (T)result;
    }

    public <T> DataSource<T> tryGetDataSource(Class<T> clazz) {
        return this.ge.getDataSource(clazz);
    }

    public <T> DataSource<T> getDataSource(Class<T> clazz) {
        DataSource<T> dsp = this.ge.getDataSource(clazz);
        if (dsp == null) {
            throw new NoDataSourceException(clazz);
        }
        return dsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void scheduleReplace(final NodeContext context, final NodeContext.PrimitiveQueryKey<T> key, final T newResult) {
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return;
        }
        Object object = ge.getPropagateListLock();
        synchronized (object) {
            List<Runnable> scheduleList = ge.getScheduleList();
            scheduleList.add(new Runnable(){

                @Override
                public void run() {
                    GENodeQueryManager.this.replaceResult(context, key, newResult, 0);
                }
            });
            if (ge.isPropagating()) {
                return;
            }
            class PropagateRunner
            implements Runnable {
                PropagateRunner() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IGraphExplorerContext ge = GENodeQueryManager.this.ge;
                    if (GENodeQueryManager.this.isDisposed()) {
                        return;
                    }
                    int delay = 0;
                    List<Runnable> todo = null;
                    Object object = ge.getPropagateListLock();
                    synchronized (object) {
                        ge.setPropagating(true);
                        List<Runnable> scheduleList = ge.getScheduleList();
                        Deque<Integer> activity = ge.getActivity();
                        activity.addFirst(scheduleList.size());
                        activity.pollLast();
                        int activityInt = 0;
                        for (int i : activity) {
                            activityInt += i;
                        }
                        ge.setActivityInt(activityInt);
                        delay = activityInt < 100 ? 10 : (activityInt < 1000 ? 500 : 3000);
                        todo = ge.getScheduleList();
                        ge.setScheduleList(new ArrayList<Runnable>());
                    }
                    try {
                        if (delay > 0) {
                            Thread.sleep(delay);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (GENodeQueryManager.this.isDisposed()) {
                        return;
                    }
                    object = ge.getPropagateLock();
                    synchronized (object) {
                        for (Runnable r : todo) {
                            r.run();
                        }
                    }
                    if (GENodeQueryManager.this.isDisposed()) {
                        return;
                    }
                    object = ge.getPropagateListLock();
                    synchronized (object) {
                        ge.setPropagating(false);
                        if (!ge.getScheduleList().isEmpty()) {
                            ge.scheduleQueryUpdate(new PropagateRunner());
                        }
                    }
                }
            }
            ge.scheduleQueryUpdate(new PropagateRunner());
        }
    }

    public boolean isDisposed() {
        if (this.disposed) {
            return true;
        }
        if (this.ge.isDisposed()) {
            this.dispose();
            return true;
        }
        return false;
    }

    public boolean isShown(NodeContext context) {
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return false;
        }
        return ge.getCache().isShown(context);
    }

    public void incRef(NodeContext context) {
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return;
        }
        ge.getCache().incRef(context);
    }

    public void decRef(NodeContext context) {
        IGraphExplorerContext ge = this.ge;
        if (this.isDisposed()) {
            return;
        }
        ge.getCache().decRef(context);
    }
}

