/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;

/**
 * @author Tuukka Lehtonen
 */
public interface IsExpandedProcessor {

    /**
     * @return all expanded nodes in the owner {@link GraphExplorer}
     */
    Collection<NodeContext> getExpanded();

    /**
     * @param context the context to test for expandedness
     * @return <code>true</code> if expanded
     */
    boolean getExpanded(NodeContext context);

    /**
     * Set internal processor expanded status without notifying the graph
     * explorer query cache of changes.
     * 
     * @param context the context to mark as expanded
     * @param expanded the new expanded state
     * @return <code>true</code> if the node's expanded state was changed,
     *         <code>false</code> otherwise
     */
    boolean setExpanded(NodeContext context, boolean expanded);

    /**
     * Replace the current processor expanded status and notify the graph
     * explorer query cache of changes.
     * 
     * @param context the context to mark as expanded
     * @param expanded the new expanded state
     * @return <code>true</code> if the node's expanded state was changed,
     *         <code>false</code> otherwise
     */
    boolean replaceExpanded(NodeContext context, boolean expanded);

}
