/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointContributionKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.ViewpointContribution;
import org.simantics.browsing.ui.content.ViewpointContributionFactory;

public class DefaultViewpointContributionProcessor extends AbstractPrimitiveQueryProcessor<ViewpointContribution> {

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.ViewpointContributionKey.class;
    }

    @Override
    public String toString() {
        return "ViewpointContributionProcessor";
    }

    @Override
    public ViewpointContribution query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<ViewpointContribution> key) {
        
        ViewpointContributionKey k = (ViewpointContributionKey) key;
        ViewpointContributionFactory vcf = k.getParameter(0);
        if (vcf == null)
            return null;
        try {
        	return vcf.create(updater, context, k);
        } catch (Throwable t) {
        	t.printStackTrace();
        	return null;
        }
        
    }

}