/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;

public class DefaultSelectedImageDecoratorFactoriesProcessor extends AbstractNodeQueryProcessor<Collection<ImageDecoratorFactory>> {

    @Override
    public QueryKey<Collection<ImageDecoratorFactory>> getIdentifier() {
        return BuiltinKeys.SELECTED_IMAGE_DECORATOR_FACTORIES;
    }

    @Override
    public Collection<ImageDecoratorFactory> query(NodeQueryManager manager, NodeContext context) {
        return manager.query(context, BuiltinKeys.IMAGE_DECORATOR_FACTORIES);
    }

    @Override
    public String toString() {
        return "SelectedImageDecoratorFactories";
    }

}