/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.utils.ui.AdaptionUtils;

public class StandardNodeTester extends PropertyTester {

    /**
     * Tests if the received resource is an instance of any of the URIs
     * listed in the arguments.
     */
    private static final String FUNCTION = "standardNodeFunction";

    @Override
    public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {

//        System.out.println("TEST: " + receiver + ", " + property + ", " + Arrays.toString(args) + ", " + expectedValue);

        if (!(receiver instanceof IStructuredSelection))
            return false;

        NodeContext context = AdaptionUtils.adaptToSingle(receiver, NodeContext.class);

        if (context == null)
            return false;

        if(FUNCTION.equals(property)) {

            Object function = context.getConstant(StandardNodes.FUNCTION);
            if(function == null) return false;
            return args[0].equals(function.toString());

        }

        return false;
    }

}
