/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.labelers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.simantics.browsing.ui.GraphExplorer.ModificationContext;
import org.simantics.browsing.ui.content.Labeler;

public class LazyContainerLabeler implements Labeler {

    private final HashMap<String, String> labels = new HashMap<String, String>(4);
    private int category;
    //private LabelerListener listener;

    public void addLabel(String key, String label) {
        @SuppressWarnings("unused")
        String old = labels.put(key, label);
        //if (listener != null && !ObjectUtils.objectEquals(label, old))
        //    listener.columnModified(key, label);
    }

    @Override
    public Map<String, String> getLabels() {
        return labels;
    }

    @Override
    public Map<String, String> getRuntimeLabels() {
        return Collections.emptyMap();
    }

    @Override
    public int getCategory() {
        return category;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    @Override
    public Modifier getModifier(ModificationContext modificationContext, String key) {
        return null;
    }

    @Override
    public void setListener(LabelerListener listener) {
        //this.listener = listener;
    }

}
