/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.internal;


/**
 * An abstract reference to a single concrete graph explorer control item.
 * 
 * @author Tuukka Lehtonen
 */
public interface UIElementReference {

    /**
     * @return <code>true</code> if this TreeReference actually contains an
     *         element behind it.
     */
    public boolean hasReference();

    /**
     * @return <code>false</code> only if {@link #hasReference()} returns true
     *         and the referenced control item not disposed. Note that
     *         this method must return <code>true</code> if
     *         {@link #hasReference()} returns <code>false</code>.
     */
    public boolean isDisposed();

}
