/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension;

import org.simantics.browsing.ui.common.extension.internal.ContributorReferenceBinding;
import org.simantics.browsing.ui.common.extension.internal.ImagerContributorReferenceBinding;
import org.simantics.browsing.ui.content.ImagerFactory;

/**
 * @author Tuukka Lehtonen
 */
public class ImagerContributorBindingExtensionManager extends ContributorBindingExtensionManager<ImagerFactory> {

    private static ImagerContributorBindingExtensionManager INSTANCE;
    
    public static synchronized ImagerContributorBindingExtensionManager getInstance() {
        if (INSTANCE == null)
            INSTANCE = new ImagerContributorBindingExtensionManager();
        return INSTANCE;
    }

    public static synchronized void dispose() {
        if (INSTANCE != null) {
            INSTANCE.close();
            INSTANCE = null;
        }
    }

    @Override
    String getExtensionPointName() {
    	return "imagerBinding";
    }
    
    @Override
    ContributorReferenceBinding<ImagerFactory> createReferenceBinding(double preference, String browseContext, String factoryId) {
    	return new ImagerContributorReferenceBinding(preference, browseContext, factoryId);
    }

}
