/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.extension;

import org.simantics.browsing.ui.content.ContributorBinding;
import org.simantics.browsing.ui.content.Contributor;


public class ContributorBindingImpl<Factory> implements ContributorBinding<Factory> {

    final private Contributor<Factory> factory;
    final private double preference;
    
    public ContributorBindingImpl(double preference, Contributor<Factory> factory) {
        this.preference = preference;
        this.factory = factory;
    }

    @Override
    public Contributor<Factory> getContributor() {
        return factory;
    }

    @Override
    public double getPreference() {
        return preference;
    }

}
