/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.NodeContextUtil;

/**
 * @author Tuukka Lehtonen
 * @since 1.24.0
 */
public class CollapseAll extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GraphExplorer explorer = HandlerUtil.getActivePart(event).getAdapter(GraphExplorer.class);
        if (explorer != null)
            NodeContextUtil.collapseAllNodes(explorer);
        return null;
    }

}
