package org.simantics.application.arguments;

import org.simantics.db.management.discovery.InetAddressUtils;

/**
 * @author Tuukka Lehtonen
 */
public class AddressValidator implements IArgumentValidator<String> {

    public static final AddressValidator INSTANCE = new AddressValidator();

    @Override
    public String isValid(String addr) {
        try {
            InetAddressUtils.parseUnresolved(addr);
            return null;
        } catch (IllegalArgumentException e) {
            return "Invalid address '" + addr + "': " + e.getMessage();
        }
    }

}
