package org.simantics.annotation.ui.actions;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.simantics.Simantics;
import org.simantics.annotation.ontology.AnnotationResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.Callback;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Jani Simomaa
 */

public class AnnotationDropActionFactory implements DropActionFactory {

	@Override
	public Runnable create(ReadGraph graph, Object target, Object source, int operation)
			throws DatabaseException {

		final Resource targetFolder = ISelectionUtils.getSinglePossibleKey(target, SelectionHints.KEY_MAIN, Resource.class);
		if (targetFolder == null) {
			return null;
		}
		Resource targetModel = graph.syncRequest(new PossibleModel(targetFolder));
		
		List<Resource> resources = ISelectionUtils.getPossibleKeys(source, SelectionHints.KEY_MAIN, Resource.class);
		AnnotationResource ANNO = AnnotationResource.getInstance(graph);
		Set<Resource> movedItems = new HashSet<Resource>();
		for (Resource resource : resources) {
			if (graph.isInstanceOf(resource, ANNO.AnnotationType) || graph.isInstanceOf(resource, ANNO.Annotation)) {
				Resource model = graph.syncRequest(new PossibleModel(resource));
				if (ObjectUtils.objectEquals(targetModel, model)) {
					movedItems.add(resource);
				}
			}
		}
		if (!movedItems.isEmpty()) {
			return addAnnotations(targetFolder, movedItems);
		}
		
		return null;
	}
	
	
	private Runnable addAnnotations(final Resource targetFolder, final Set<Resource> movedAnnotationItems) {
		
		return new Runnable() {
			
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
						
						Layer0 L0 = Layer0.getInstance(graph);
						for (Resource annotation : movedAnnotationItems) {
							graph.deny(annotation, L0.PartOf);
							graph.claim(targetFolder, L0.ConsistsOf, annotation);
						}
							
						String name = NameUtils.getSafeName(graph, targetFolder);
						CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
				        graph.addMetadata(cm.add("Moved " + movedAnnotationItems.size() + " annotations to folder " + name + ", resource " + targetFolder));
					}
				}, new Callback<DatabaseException>() {
					
					@Override
					public void run(DatabaseException e) {
						if (e!= null)
							ErrorLogger.defaultLogError(e);
						
					}
				});
				
			}
		};
	}
	
	
}
