/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class GridVisibleRangeSupport {
    private Collection rangeChangeListener;
    private Grid grid;
    private Grid.GridVisibleRange oldRange = new Grid.GridVisibleRange();
    private Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            GridVisibleRangeSupport.this.calculateChange();
        }
    };

    private GridVisibleRangeSupport(Grid grid) {
        this.grid = grid;
        this.grid.setSizeOnEveryItemImageChange(true);
        grid.addListener(9, this.paintListener);
    }

    public void addRangeChangeListener(VisibleRangeChangedListener listener) {
        if (this.rangeChangeListener == null) {
            this.rangeChangeListener = new ArrayList();
        }
        this.rangeChangeListener.add(listener);
    }

    public void removeRangeChangeListener(VisibleRangeChangedListener listener) {
        if (this.rangeChangeListener != null) {
            this.rangeChangeListener.remove(listener);
            if (this.rangeChangeListener.size() == 0) {
                this.rangeChangeListener = null;
            }
        }
    }

    private void calculateChange() {
        if (this.rangeChangeListener != null) {
            Grid.GridVisibleRange range = this.grid.getVisibleRange();
            ArrayList<GridItem> lOrigItems = new ArrayList<GridItem>();
            lOrigItems.addAll(Arrays.asList(this.oldRange.getItems()));
            ArrayList<GridItem> lNewItems = new ArrayList<GridItem>();
            lNewItems.addAll(Arrays.asList(range.getItems()));
            Iterator it = lNewItems.iterator();
            while (it.hasNext()) {
                if (!lOrigItems.remove(it.next())) continue;
                it.remove();
            }
            ArrayList<GridColumn> lOrigColumns = new ArrayList<GridColumn>();
            lOrigColumns.addAll(Arrays.asList(this.oldRange.getColumns()));
            ArrayList<GridColumn> lNewColumns = new ArrayList<GridColumn>();
            lNewColumns.addAll(Arrays.asList(range.getColumns()));
            it = lNewColumns.iterator();
            while (it.hasNext()) {
                if (!lOrigColumns.remove(it.next())) continue;
                it.remove();
            }
            if (lOrigItems.size() != 0 || lNewItems.size() != 0 || lOrigColumns.size() != 0 || lNewColumns.size() != 0) {
                RangeChangedEvent evt = new RangeChangedEvent(this.grid, range);
                evt.addedRows = new GridItem[lNewItems.size()];
                lNewItems.toArray(evt.addedRows);
                evt.removedRows = new GridItem[lOrigItems.size()];
                lOrigItems.toArray(evt.removedRows);
                evt.addedColumns = new GridColumn[lNewColumns.size()];
                lNewColumns.toArray(evt.addedColumns);
                evt.removedColumns = new GridColumn[lOrigColumns.size()];
                lNewColumns.toArray(evt.removedColumns);
                it = this.rangeChangeListener.iterator();
                while (it.hasNext()) {
                    ((VisibleRangeChangedListener)it.next()).rangeChanged(evt);
                }
            }
            this.oldRange = range;
        }
    }

    public static GridVisibleRangeSupport createFor(Grid grid) {
        return new GridVisibleRangeSupport(grid);
    }

    public static class RangeChangedEvent
    extends EventObject {
        private static final long serialVersionUID = 1L;
        public GridItem[] addedRows;
        public GridItem[] removedRows;
        public GridColumn[] addedColumns;
        public GridColumn[] removedColumns;
        public Grid.GridVisibleRange visibleRange;

        RangeChangedEvent(Grid grid, Grid.GridVisibleRange visibleRange) {
            super((Object)grid);
            this.visibleRange = visibleRange;
        }
    }

    public static interface VisibleRangeChangedListener {
        public void rangeChanged(RangeChangedEvent var1);
    }
}

