/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.internal.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.simantics.utils.ui.internal.awt.EmbeddedChildFocusTraversalPolicy;
import org.simantics.utils.ui.internal.awt.RecursiveContainerListener;
import org.simantics.utils.ui.internal.awt.SwtFocusHandler;

public class AwtFocusHandler
implements FocusListener,
ContainerListener,
WindowFocusListener {
    private Frame frame;
    private SwtFocusHandler swtHandler;
    private RecursiveContainerListener containerListener;
    private boolean awtHasFocus = false;
    private Component currentComponent = null;

    public AwtFocusHandler(Frame frame) {
        assert (frame != null);
        this.frame = frame;
        this.containerListener = new RecursiveContainerListener(this);
        frame.addContainerListener(this.containerListener);
        frame.addWindowFocusListener(this);
    }

    public void setSwtHandler(SwtFocusHandler handler) {
        assert (handler != null);
        assert (this.swtHandler == null);
        this.swtHandler = handler;
    }

    public void dispose() {
        assert (this.frame != null);
        this.frame.removeWindowFocusListener(this);
        this.frame.removeContainerListener(this.containerListener);
        this.frame = null;
        this.currentComponent = null;
    }

    void gainFocus() {
        Component component;
        assert (EventQueue.isDispatchThread());
        if (this.frame == null) {
            return;
        }
        FocusTraversalPolicy policy = this.frame.getFocusTraversalPolicy();
        if (policy instanceof EmbeddedChildFocusTraversalPolicy) {
            EmbeddedChildFocusTraversalPolicy embeddedPolicy = (EmbeddedChildFocusTraversalPolicy)policy;
            component = embeddedPolicy.getCurrentComponent(this.frame);
        } else {
            component = policy.getDefaultComponent(this.frame);
        }
        if (component != null) {
            component.requestFocus();
        }
        this.awtHasFocus = true;
    }

    void transferFocusNext() {
        assert (this.swtHandler != null);
        assert (this.awtHasFocus);
        this.awtHasFocus = false;
        this.swtHandler.gainFocusNext();
    }

    void transferFocusPrevious() {
        assert (this.swtHandler != null);
        assert (this.awtHasFocus);
        this.awtHasFocus = false;
        this.swtHandler.gainFocusPrevious();
    }

    boolean awtHasFocus() {
        return this.awtHasFocus;
    }

    Component getCurrentComponent() {
        return this.currentComponent;
    }

    @Override
    public void focusGained(FocusEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        this.currentComponent = e.getComponent();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        e.getChild().addFocusListener(this);
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        assert (e != null);
        assert (EventQueue.isDispatchThread());
        e.getChild().removeFocusListener(this);
    }

    @Override
    public void windowGainedFocus(WindowEvent e) {
        assert (EventQueue.isDispatchThread());
        this.awtHasFocus = true;
    }

    @Override
    public void windowLostFocus(WindowEvent e) {
        Caret caret;
        assert (e != null);
        assert (this.swtHandler != null);
        assert (EventQueue.isDispatchThread());
        this.hidePopups();
        if (this.currentComponent instanceof JTextComponent && (caret = ((JTextComponent)this.currentComponent).getCaret()) != null) {
            caret.setSelectionVisible(false);
        }
        this.awtHasFocus = false;
    }

    private boolean hidePopups() {
        boolean result = false;
        ArrayList popups = new ArrayList();
        assert (EventQueue.isDispatchThread());
        Frame frame = this.frame;
        if (frame == null) {
            return result;
        }
        this.findContainedPopups(frame, popups);
        this.findOwnedPopups(frame, popups);
        for (Component popup : popups) {
            if (!popup.isVisible()) continue;
            result = true;
            popup.setVisible(false);
        }
        return result;
    }

    private void findOwnedPopups(Window window, List popups) {
        assert (window != null);
        assert (EventQueue.isDispatchThread());
        Window[] ownedWindows = window.getOwnedWindows();
        int i = 0;
        while (i < ownedWindows.length) {
            this.findContainedPopups(ownedWindows[i], popups);
            this.findOwnedPopups(ownedWindows[i], popups);
            ++i;
        }
    }

    private void findContainedPopups(Container container, List popups) {
        assert (container != null);
        assert (popups != null);
        assert (EventQueue.isDispatchThread());
        Component[] components = container.getComponents();
        int i = 0;
        while (i < components.length) {
            Component c = components[i];
            if (c instanceof JPopupMenu) {
                popups.add(c);
            } else if (c instanceof Container) {
                this.findContainedPopups((Container)c, popups);
            }
            ++i;
        }
    }

    public void postHidePopups() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AwtFocusHandler.this.hidePopups();
            }
        });
    }
}

