/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 26.12.2005
 * @Author Toni Kalajainen
 */
package org.simantics.utils.ui.workbench.dialogs;


/**
 * PropertyLineVerifyListener is a listener for EditablePropertyDialog.
 * It is used for verifying property editor value 
 * 
 * @see PropertyEditorDialog
 */
public interface PropertyLineVerifyListener 
{

    /**
     * Verify value
     * @param key key
     * @param value value
     * @return true if value is verified
     */
    public boolean verifyValue(String key, String value);
}
