package org.simantics.scl.ui.editor2;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.scl.compiler.source.ModuleSource;
import org.simantics.scl.osgi.SCLOsgi;

public class StandardSCLModuleEditorInput implements SCLModuleEditorInput, IPersistableElement {

    private final String moduleName;
    
    public StandardSCLModuleEditorInput(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public boolean exists() {
        return SCLOsgi.SOURCE_REPOSITORY.getModuleSource(moduleName, null) != null;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }
    
    @Override
    public String getModuleName() {
        return moduleName;
    }

    @Override
    public String getName() {
        int p = moduleName.lastIndexOf('/');
        if(p >= 0)
            return moduleName.substring(p+1);
        else
            return moduleName;
    }

    @Override
    public IPersistableElement getPersistable() {
        return this;
    }

    @Override
    public String getToolTipText() {
        return moduleName;
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if(adapter.equals(ModuleSource.class))
            return (T)SCLOsgi.SOURCE_REPOSITORY.getModuleSource(moduleName, null);
        if(adapter.equals(IPersistableElement.class))
            return (T)this;
        return null;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((moduleName == null) ? 0 : moduleName.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null || getClass() != obj.getClass())
            return false;
        StandardSCLModuleEditorInput other = (StandardSCLModuleEditorInput) obj;
        return moduleName.equals(other.moduleName);
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putTextData(moduleName);
    }

    @Override
    public String getFactoryId() {
        return "org.simantics.scl.ui.editor.inputFactory";
    }

}
