package org.simantics.scl.ui.editor2;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor.completion.SCLTextEditorEnvironment;

public class SCLModuleEditor2 extends TextEditor {
    private boolean disposed = false;
    ResourceManager resourceManager;

    public SCLModuleEditor2() {
        super();
        resourceManager = new LocalResourceManager(JFaceResources.getResources());
        SCLSourceViewerConfigurationNew sourceViewerConfiguration = new SCLSourceViewerConfigurationNew(resourceManager);
        setDocumentProvider(new SCLModuleEditor2DocumentProvider(sourceViewerConfiguration));
        setSourceViewerConfiguration(sourceViewerConfiguration);
    }
    
    @Override
    public boolean isTabsToSpacesConversionEnabled() {
        return true;
    }
    
    @Override
    public void init(IEditorSite site, IEditorInput input)
            throws PartInitException {
        super.init(site, input);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        StatusLineContributionItem statusLineContribution = new StatusLineContributionItem(
                ITextEditorActionConstants.STATUS_CATEGORY_INPUT_POSITION,
                true, 14);
        setStatusField(statusLineContribution,
                ITextEditorActionConstants.STATUS_CATEGORY_INPUT_POSITION);
        getEditorSite().getActionBars().getStatusLineManager().add(statusLineContribution);
        getEditorSite().getActionBars().updateActionBars();
        getEditorSite().getService(IContextService.class).activateContext("org.simantics.scl.ui.editor");
        updatePartName();
    }

    protected void updatePartName() {
        setPartName(getEditorInput().getName());
    }
    
    @Override
    public void dispose() {
        disposed = true;
        super.dispose();
        resourceManager.dispose();
    }

    public boolean isDisposed() {
        return disposed;
    }
    
    public SCLTextEditorEnvironment getSCLTextEditorEnvironment() {
        return ((SCLSourceViewerConfigurationNew)getSourceViewerConfiguration())
                .getSclTextEditorEnvironment();
    }

    public IDocument getDocument() {
        return getSourceViewer().getDocument();
    }
}
