package org.simantics.scl.ui.editor2;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;

public class DebugPartionTokenScanner implements IPartitionTokenScanner {
    IPartitionTokenScanner base;

    public DebugPartionTokenScanner(IPartitionTokenScanner base) {
        this.base = base;
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        System.out.println(">>> setRange(" + offset + ", " + length + ")");
        base.setRange(document, offset, length);
    }

    @Override
    public IToken nextToken() {
        IToken result = base.nextToken();
        System.out.println(">>> nextToken -> " + result + " " + result.getData());
        return result;
    }

    @Override
    public int getTokenOffset() {
        int result = base.getTokenOffset();
        System.out.println(">>> getTokenOffset -> " + result);
        return result;
    }

    @Override
    public int getTokenLength() {
        int result = base.getTokenLength();
        System.out.println(">>> getTokenLength -> " + result);
        return result;
    }

    @Override
    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        System.out.println(">>> setPartialRange(" + offset + ", " + length + ", " + contentType + ", " + partitionOffset + ")");
        base.setPartialRange(document, offset, length, contentType, partitionOffset);
    }
    
    
}
