/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils.variable;

/**
 * A container for a single dynamic part of a dynamic-enabled variable of a
 * scene graph node. Dynamic-enabled means a variable that potentially has two
 * values: one static (~ default) and one dynamic. If the dynamic part has a
 * non-null value it should always be used instead of the static value. Use
 * {@link #getActiveValue()} to get the current variable value to follow this
 * policy in your client code.
 * 
 * <p>
 * Variables generally determine the way a node gets rendered.
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <T> type of the contained field
 */
public class DynamicVariable<T> {

    protected T dynamicValue;

    public T getDynamicValue() {
        return dynamicValue;
    }

    public void setDynamicValue(T dynamicValue) {
        this.dynamicValue = dynamicValue;
    }

    /**
     * Resets the dynamic part of the variable to null.
     */
    public void reset() {
        setDynamicValue(null);
    }

}
