/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events;

import java.io.Serializable;

import org.simantics.scenegraph.g2d.events.MouseEvent.MouseClickEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;

/**
 * @see EventTypes
 * @see TimeEvent Time Heatbeat event
 * @see CommandEvent Command event
 * @see KeyEvent Keyboard events
 * @see MouseClickEvent Mouse click event
 * @see MouseEvent Other mouse event
 * 
 * @author Toni Kalajainen
 */
public abstract class Event implements Cloneable, Serializable {

    private static final long     serialVersionUID = -6939802269348658216L;

    /**
     * Object describing the context of event occurrence. Usually an AWT UI
     * component.
     */
    public transient final Object context;

    /**
     * Time when event occured. The value is relative; values are comparable
     * only in the same domain of events (e.g. mouse or key events). The unit is
     * millisecond.
     * 
     * TODO MAKE BETTER SPECIFICATION
     */
    public final long             time;

    public Event(Object context, long time) {
        this.context = context;
        this.time = time;
    }

    public Object getContext() {
        return context;
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[time=" + time + "]";
    }

}
