/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.Component;
import java.awt.RenderingHints.Key;
import java.awt.geom.Rectangle2D;

/**
 * @author Tuukka Lehtonen
 * See {@link G2DPDFRenderingHints}
 */
public final class G2DRenderingHints {

    /**
     * A rendering hint for storing the boundaries of the control area within a
     * Graphics2D instance.
     */
    public static final Key KEY_CONTROL_BOUNDS = new Key(1000) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Rectangle2D;
        }
    };

    /**
     * A rendering hint for storing the root AWT Component on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_COMPONENT      = new Key(1001) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Component;
        }
    };

}