/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui.contribution;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.SWT;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;

/**
 * @author Tuukka Lehtonen
 */
public enum IssueLabelDecorationRule implements LabelDecorationRule {

    INSTANCE;

    public static IssueLabelDecorationRule get() {
        return INSTANCE;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        Resource issue = (Resource) content;

        final boolean hidden = graph.hasStatement(issue, IssueResource.getInstance(graph).Hidden);
        final boolean user = graph.hasStatement(issue, IssueResource.getInstance(graph).UserIssue);
        final boolean resolved = graph.hasStatement(issue, IssueResource.getInstance(graph).Resolved);
        if (!hidden && !user && !resolved)
            return null;

        return new LabelDecorator.Stub() {
            @SuppressWarnings("unchecked")
            @Override
            public <F> F decorateFont(F font, String column, int itemIndex) {
                int style = 0;
                style |= resolved ? SWT.ITALIC : 0;
                return style != 0 ? (F) ((FontDescriptor) font).setStyle(style) : font;
            }
            @SuppressWarnings("unchecked")
            @Override
            public <C> C decorateForeground(C color, String column, int itemIndex) {
                if (hidden)
                    return (C) Constants.HIDDEN_FG;
                return color;
            }
            @SuppressWarnings("unchecked")
            @Override
            public <C> C decorateBackground(C color, String column, int itemIndex) {
                if (user)
                    return (C) Constants.USER_BG;
                return color;
            }
        };
    }

}
