/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.ui;

import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.strings.StringUtils;

public class IssueLabelRule implements LabelRule {

    public static final IssueLabelRule INSTANCE = new IssueLabelRule();

    private static final String[] COLS = new String[] { ColumnKeys.SINGLE, "Resource", "Path" };

    public IssueLabelRule() {
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    @Override
    public Map<String,String> getLabel(ReadGraph graph, Object content) throws DatabaseException {

        Variable issue = (Variable)content;
        String description = StringUtils.safeString( (String) issue.getPossiblePropertyValue(graph, "HasDescription") );
        String resource = StringUtils.safeString( (String) issue.getPossiblePropertyValue(graph, "resource") );
        String path = StringUtils.safeString( (String) issue.getPossiblePropertyValue(graph, "path") );

        String[] result = new String[] { description, resource, path };
        return new ArrayMap<String, String>(COLS, result);

    }
}
