/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;
import java.io.StringWriter;

import org.simantics.db.ReadGraph;

public class PageHeaderSection implements ResourceBrowserSection {

    private StringWriter stringWriter = new StringWriter();
    private PrintWriter headWriter = new PrintWriter(stringWriter);

    @Override
    public double getPriority() {
        return Double.NEGATIVE_INFINITY;
    }

    public PrintWriter getHeadWriter() {
        return headWriter;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) {
        out.println("<!DOCTYPE html>");
        out.println("<html lang=\"en\">");
        out.println("<head>");
        out.println("<meta charset=\"utf-8\">");
        out.println("<title>Resource Browser</title>");
        //out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"/css/jquery.dataTables.css\" />");
        //out.println("<script type=\"text/javascript\" charset=\"utf8\" src=\"/js/jquery-1.10.2.min.js\"></script>");
        //out.println("<script type=\"text/javascript\" charset=\"utf8\" src=\"/js/jquery-ui.min.js\"></script>");
        //out.println("<script type=\"text/javascript\" charset=\"utf8\" src=\"/js/jquery.dataTables.min.js\"></script>");
        out.write(stringWriter.toString());
        out.println("</head>");
        out.println("<body>");
    }

}
