/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.request.RequestFlags;

abstract public class UnaryQuery<Procedure> extends CacheEntryBase implements Query {
	
    final public int id;

    public UnaryQuery(int r) {
        assert(r != 0);
    	this.id = r;
    }
    
    @Override
    int makeHash() {
    	return id;
    }
    
    @Override
    public int type() {
        return RequestFlags.INVALIDATE;
    }
    
    @Override
    final public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (getClass() != object.getClass())
            return false;
        UnaryQuery<?> other = (UnaryQuery<?>)object;
        return id == other.id;
    }
    
    @Override
    final public Query getQuery() {
        assert(!isDiscarded());
        return this;
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, Object provider, CacheEntry entry) {
        recompute(graph, (QueryProcessor)provider);
    }
    
    @Override
    public void performFromCache(ReadGraphImpl graph, Object provider, Object procedure) {
        performFromCache(graph, (QueryProcessor)provider, (Procedure)procedure);
    }
    
    abstract public void recompute(ReadGraphImpl graph, QueryProcessor provider);
    abstract public Object computeForEach(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure, boolean store);
    abstract public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, Procedure procedure);
    abstract public void putEntry(QueryProcessor provider);
    abstract public void removeEntry(QueryProcessor provider);
    abstract public UnaryQuery<Procedure> getEntry(QueryProcessor provider);
	
    public Object get(ReadGraphImpl graph, QueryProcessor processor, Object procedure) throws Throwable {
        if(procedure != null) {
            performFromCache(graph, processor, procedure);
        } else {
            checkAndThrow();
        }
        return getResult();
    }
    
    @Override
    boolean isImmutable(ReadGraphImpl graph) throws DatabaseException {
		return graph.processor.isImmutable(id);
    }
    
}
