/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import gnu.trove.procedure.TIntProcedure;

import java.util.concurrent.Semaphore;

import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.procedure.ListenerBase;

final public class SuperTypes extends UnaryQuery<InternalProcedure<IntSet>> {
    
//	public ArrayList<InternalProcedure<IntSet>> procs = null;
	
    private SuperTypes(final int resource) {
        super(resource);
    }
    
    final static SuperTypes runner(ReadGraphImpl graph, final int r, final CacheEntry parent, final QueryProcessor provider, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {

    	SuperTypes entry = (SuperTypes)provider.superTypesMap.get(r);
        if(entry == null) {
        	
        	entry = new SuperTypes(r);
        	entry.setPending();
        	entry.clearResult(provider.querySupport);
        	entry.putEntry(provider);
        	
            provider.performForEach(graph, entry, parent, listener, procedure);
            
            return entry;
            
        } else {
        	
            if(!entry.isReady()) {
            	synchronized(entry) {
                    if(!entry.isReady()) {
                        throw new IllegalStateException();
//                    	if(entry.procs == null) entry.procs = new ArrayList<InternalProcedure<IntSet>>();
//                    	entry.procs.add(procedure);
//						provider.registerDependencies(graph, entry, parent, listener, procedure, false);
//                    	return entry;
                    }
            	}
            }
            provider.performForEach(graph, entry, parent, listener, procedure);
        }
        
        return entry;

    }
    
    final public static SuperTypes queryEach(ReadGraphImpl graph, final int r, final QueryProcessor provider, final CacheEntry parent, final ListenerBase listener, final InternalProcedure<IntSet> procedure) {
    
        if(parent == null && listener == null) {
        	SuperTypes entry = (SuperTypes)provider.superTypesMap.get(r);
        	if(entry != null && entry.isReady()) { 
        		entry.performFromCache(graph, provider, procedure);
        		return entry;
        	}
        }
        
        return runner(graph, r, parent, provider, listener, procedure);
         
    }
 	
 	@Override
 	public UnaryQuery<InternalProcedure<IntSet>> getEntry(QueryProcessor provider) {
        return provider.superTypesMap.get(id);
 	}
 	
 	@Override
 	public void putEntry(QueryProcessor provider) {
        provider.superTypesMap.put(id, this);
 	}

 	@Override
 	final public void removeEntry(QueryProcessor provider) {
 		provider.superTypesMap.remove(id);
 	}

 	@Override
 	public Object computeForEach(ReadGraphImpl graph, final QueryProcessor provider, final InternalProcedure<IntSet> procedure, boolean store) {

        final int inherits = provider.getInherits();
        
        final CacheEntry parent = graph.parent;
        
        assert(graph.parent != this);

        final IntSet result = new IntSet(provider.querySupport);
        
        final TIntProcedure addToResult = new TIntProcedure() {
            @Override
            public boolean execute(int r) {
            	synchronized(result) {
            		result.add(r);
            	}
                return true;
            }
        };

        DirectObjects.queryEach(graph, id, inherits, provider, this, null, new SyncIntProcedure() {
            
            @Override
            public void run(ReadGraphImpl graph) {

                addOrSet(graph, result, provider);
                procedure.execute(graph, result);
                
            }
            
            @Override
            public void execute(ReadGraphImpl graph, final int i) {
                
            	assert(graph.parent == parent);
            	
            	synchronized(result) {
            		result.add(i);
            	}
                
                inc();

                SuperTypes.queryEach(graph, i, provider, SuperTypes.this, null, new InternalProcedure<IntSet>() {

                    @Override
                    public void execute(ReadGraphImpl graph, IntSet types) {

                        types.forEach(addToResult);
                        dec(graph);
                        
                    }
    				
    				@Override
    				public void exception(ReadGraphImpl graph, Throwable t) {
    					procedure.exception(graph, t);
    	            }

                });
                
            }

            @Override
            public void finished(ReadGraphImpl graph) {
                dec(graph);
            }
            
        });
        
        return result;
        
    }
    
    @Override
    public String toString() {
    	return "SuperTypes2[" + id + "]";
    }

    private void addOrSet(ReadGraphImpl graph, final IntSet value, QueryProcessor provider) {
    	
        assert(!isReady());

//        ArrayList<InternalProcedure<IntSet>> p = null;

        synchronized(this) {
        
            value.trim();
            setResult(value);
            setReady();
//            p = procs;
//            procs = null; 
        
        }

//        if(p != null) {
//	        IntSet v = (IntSet)getResult();
//	        if(v != null) {
//	            for(InternalProcedure<IntSet> proc : p) proc.execute(graph, v);
//	        }
//        }
        
    }

    @Override
    public Object performFromCache(ReadGraphImpl graph, QueryProcessor provider, InternalProcedure<IntSet> procedure) {
    	
    	assert(isReady());

    	if(handleException(graph, procedure)) return null;
    	
    	IntSet result = getResult();
    	
        procedure.execute(graph, result);
        
        return result;
        
    }
    
    @Override
    public void recompute(ReadGraphImpl graph, QueryProcessor provider) {
        
        final Semaphore s = new Semaphore(0);

        computeForEach(graph, provider, new InternalProcedure<IntSet>() {

        	@Override
        	public void execute(ReadGraphImpl graph, IntSet result) {
                s.release();
        	}

            @Override
            public void exception(ReadGraphImpl graph, Throwable t) {
            	s.release();
                new Error("Error in recompute.", t).printStackTrace();
            }

        }, true);

        while(!s.tryAcquire()) {
        	provider.resume(graph);
        }
        
    }
    
    @Override
    boolean isImmutable(ReadGraphImpl graph) {
    	return graph.processor.isImmutable(id);
    }
    
}
